/*
  this class controls the different decoders.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */






#ifndef __YAFAMPLIFIER_H
#define __YAFAMPLIFIER_H

#include <producer/yaf/yafGenerator.h>
#include <producer/image/imageGenerator.h>

#include <devices/genericPlayer.h>
#include <util/ptrArray.h>
#include <amplifier/amplifierConfig.h>
#include <producer/core/decoderID.h>


/**
   A factory for GenericPlayers.
   Please use the createStandardDecoderID call to get a default
   config. then add your own switches to it.
   DO NOT MAKE AN INSTANCE OF DECODERID!
   (amplifier stores a few secret switches in decoderID!)
*/

class Amplifier  {

 public:
  Amplifier();
  ~Amplifier();
 
  // returns the id for the decoder. types defined in AmplifierConfig.h
  static GenericPlayer* createPlayer(int playerTyp);
  static GenericPlayer* createPlayer(DecoderID* decoderID);
  /**
     expect a decoder id created with createStandardDecoderID.
  */  
  static DecoderID*     createStandardDecoderID(int playerTyp);
 private:

  static YafGenerator* createYafGenerator(DecoderID* decoder);
  static DecoderID* createDecoderID(int playerTyp,int argn, char** args);

};

#endif

