/*
  creates/deletes MemChunks
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GARBAGECOLLECTOR_H
#define __GARBAGECOLLECTOR_H

#include <pthread.h>

#include <deviceConfig/mem/memManager.h>
#include <iostream.h>

/**
   The garbageCollector creates MemChunk objects. If you
   delete MemChunk objects you <b>must</b> use for this
   the garbageCollector. He checks if someone
   holds a lock on the memChunk. If a lock is hold, he
   cannot delete the memory. He then checks if it is
   a shared memory. If yes he memcpy this memory
   and makes out of the memChunk a "standalone" memory
   object. This standalone memory object is then
   inserted in a "deleteIfNoLocks" list.
   <b>Note</b><p>
   The library uses many threads, and it must be guaranteed,
   that no thread has currently a pointer _into_ the memChunk
   in his execution stack. This condition it fullfilled if
   the thread "sits" in the genericPlayer.
   A MemManager, who gets a shutdown request, must make sure
   that all threads of all genericPlayers are locked. And
   the Implementor of "devices" should be aware of this "memChunk
   problem". But this is the only solution, to graphwide shared
   memory. If you wouldn't use graphwide shared memory you
   must memcpy everything! The slowdown would be _dramatic_.
   This solution works. Its considerable easy, and is a good
   tradeoff.
*/


class GarbageCollector {

 public:

  GarbageCollector();
  ~GarbageCollector();

  static void init();
  static MemChunk* createMemChunk(struct MemManager* memManager,int size);
  static int deleteMemChunk(MemChunk* memChunk);

  static void makeGarbageCollection();
  static int canMakeCollection();
};


#endif



