/*
  generic audiodevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/audioDevice.h>



AudioDevice::AudioDevice(const char* device):OutputDevice("AudioDevice") {
  audioWrapper=new AudioWrapper();
  audioInfo=new AudioInfo();
  statusInfo=new StatusInfo();
  nativeMixerDevice= new NativeMixerDevice("/dev/mixer");
  nativeMixerDevice->open();


  lneedInit=true;
  lAutoInit=true;
  lEnabled=true;
}


AudioDevice::~AudioDevice() {
  close();
  delete audioWrapper;
  delete nativeMixerDevice;
}


char* AudioDevice::getNodeName() {
  return "AudioDevice";
}

int AudioDevice::open() {
  int back=audioWrapper->openDevice();
  return back;
}


int AudioDevice::isOpen() {
  return audioWrapper->isOpenDevice();
}


int AudioDevice::close() {
  audioWrapper->closeDevice();
  return true;
}


int AudioDevice::init(int sampleSize,int speed,int stereo) {
  audioInfo->setStereo(stereo);
  audioInfo->setSampleSize(sampleSize);
  audioInfo->setSpeed(speed);
  return init(true);
}


int AudioDevice::init(int lForceSet) {
  int stereo=audioInfo->getStereo();
  int sampleSize=audioInfo->getSampleSize();
  int speed=audioInfo->getSpeed();
  if (isOpen() == false) {
    return false;
  } 
  if (lForceSet) {
    audioWrapper->init(sampleSize,speed,stereo);
    return true;
  }
  if (lAutoInit) {
    audioWrapper->init(sampleSize,speed,stereo);
    return true;
  } 
  return false;
}


int AudioDevice::getAutoInit() {
  return lAutoInit;
}

void AudioDevice::setAutoInit(int lAutoInit) {
  this->lAutoInit=lAutoInit;
  if (lAutoInit == true) {
    lneedInit=true;
  }
}


StatusInfo* AudioDevice::getStatusInfo() {
  return statusInfo;
}


void AudioDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  if (lEnabled == false) {
    return;
  }
  AudioStream* audioStream=config->getAudioStream();
  AudioBuffer* buffer=audioStream->getAudioBuffer();
  MemChunk* memChunk=buffer->getMemChunk();
  StatusInfo* statusInfoStream=audioStream->getStatusInfo();
  AudioInfo* audioInfoStream=audioStream->getAudioInfo();

  // We ignore statusChange messages, because otherwise
  // it is possible that we initialize /dev/dsp with "strange"
  // values. (Linux ignores this FreeBSD hangs)
  if (statusInfoStream->getChange()) {
    statusInfoStream->copyTo(statusInfo);
    if (statusInfoStream->getStatus()==_STATUS_STOPPED) {
      getEventQueue()->sendEvent(_AUDIODEVICE_CLOSE_REQUEST);
    }
    return;
  }

  if (!(audioInfoStream->equals(audioInfo)) || lneedInit) {
    audioInfoStream->copyTo(audioInfo);
    init(false);
  }
  nativeMixerDevice->writeInLock();
  nativeMixerDevice->writeIn(source,config);
  nativeMixerDevice->writeInUnlock();

  lneedInit=false;
  if (audioWrapper->isOpenDevice()) {
    if (memChunk != NULL) {
      if (memChunk->getLen() > 0) {
	int didWrite=rawWrite(memChunk->getPtr(),memChunk->getLen());
	if (didWrite == -1) {
	  perror("********* write in AudioDevice");
	}
	if (didWrite != memChunk->getLen()){
	  lneedInit=true;
	}
      } else {
	cout << "memChunk len is 0"<<endl;
      }
    } else {
      cout << "memChunk is NULL!"<<endl;
    }
  } else {
    if (open() == false) {
      getEventQueue()->sendEvent(_AUDIODEVICE_CANNOT_OPEN);
    }
    NodeDevice::doSleep(1500);
    lneedInit=true;
  }
}
  



int AudioDevice::rawWrite(char* buf,int len) {
  return audioWrapper->write(buf,len);
}






int AudioDevice::getEnabled() {
  return lEnabled;
}


void AudioDevice::setEnabled(int lEnable) {
  // block the device for a short time
  writeInLock();
  this->lEnabled=lEnable;
  if ((isOpen() == true) && (lEnabled==false)) {
    close();
  }
  writeInUnlock();
}

