/*
  virtual dummy implementation for a NASDevice 
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __NASDEVICEVIRTUAL_H
#define __NASDEVICEVIRTUAL_H


#include <devices/outputDevice.h>
#include <stdio.h>

/**
   Empty implementation of a nasDevice. The reason is that
   during configure time we check for nas *silently* and include
   it if we find the necessary includes/libraries.
   The user should not need to configure it with switches.
*/ 


class NASDeviceVirtual :public OutputDevice {
  
  int lEnabled; 


 public:
  NASDeviceVirtual();
  ~NASDeviceVirtual();

  int getEnabled();
  void setEnabled(int lEnable);

  // displayString eg: tcp/host.domain.com:8000
  virtual int open(char* displayString);

  virtual char* getDisplay();
  virtual void setDisplay(char* displayString);
  
  virtual int getGain();
  // gain from 0..100
  virtual void setGain(int val); 

  virtual const char* getServerString();
  virtual const char* getVendorString();
  virtual int getMajorProtocolVersion();
  virtual int getMinorProtocolVersion();

  virtual int close();
  virtual int isOpen();

  void writeIn(NodeDevice* source,DeviceConfig* buf);

  char* getNodeName();
  virtual int isCompiledIn();
};

#endif
  
  
