/*
  a FFT filter with real/imagery part
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __FFTFILTER_H
#define __FFTFILTER_H



#include <filter/filter.h>
#include <util/fix_fft.h>


/**
   Part of the code comes from x11amp. They use the same fft class.
*/
  

class FixFFTFilter : public Filter {

  FixFFT* fixFFT;
  int fftPoints;
  fixed* redata;  // size of 2*fftPoints because complex
  fixed* imdata;
  fixed* loud;
  int analyserSize;
  
 public:
  FixFFTFilter(int fftPoints,int analyserSize);
  ~FixFFTFilter();
  int fft16(DeviceConfig* input);
  int getPoints();
  int getAnalyserSize();
  short* getPointPtr();


};


#endif
