/*
  implements a directed stream graph
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <graph/yafGraph.h>
#include <graph/nodeConnection.h>

YafGraph::YafGraph() {
  int i;
  for(i=0;i<_MAX_CONNECTION;i++) {
    connectTable[i]=new NodeConnection();
  }
}


YafGraph::~YafGraph() {
  int i;

  for(i=0;i<_MAX_CONNECTION;i++) {
    delete connectTable[i];
  }  
}


void YafGraph::connect(NodeDevice* source,NodeDevice* listener){
  int i;
  if ((source == NULL) || (listener == NULL)) {
    cout << "inserting null source/listener !"<<endl;
    exit(0);
  }

  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->getValid()==false) {
      connectTable[i]->setSource(source);
      connectTable[i]->setListener(listener);
      connectTable[i]->setValid(true); 
      return;
    }
  }    
  cout << "YafGraph::connect maximum connections reached! ->exiting"<<endl;
  exit(0);

  
}


void YafGraph::disconnect(NodeDevice* source,NodeDevice* listener){
  int i;
  NodeConnection* connection;
  
  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->getValid()==true) {
      connection=connectTable[i];
      if ( (connection->getSource() == source) && 
	   (connection->getListener() == listener) ) {
	connection->setValid(false);
	return;
      }
    }
  }      
}


void YafGraph::getListeners(NodeDevice* source, Edges* edges){
  int i;
  NodeConnection* connection;
  edges->clear();

  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->getValid()==true) {
      connection=connectTable[i];
      if (connection->getSource() == source) {
	int pos=edges->getElements();
	edges->setNodeDevice(pos,connection->getListener());
	edges->setElements(pos+1);
      }
    }
  }       
}


void YafGraph::getSources(NodeDevice* listener, Edges* edges){
  int i;
  NodeConnection* connection;
  edges->clear();
  for(i=0;i<_MAX_CONNECTION;i++) {
    if (connectTable[i]->getValid()==true) {
      connection=connectTable[i];
      if (connection->getListener() == listener) {
	int pos=edges->getElements();
	edges->setNodeDevice(pos,connection->getSource());
	edges->setElements(pos+1);
      }
    }
  }         
}








