/*
  buffer capabilites for a stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __YAFSTREAM_H
#define __YAFSTREAM_H
#include <pthread.h>

#include <yafcore/buffer.h>
#include <yafxplayer/xplayerRuntime.defs>
#include <deviceConfig/info/audioBuffer.h>
#include <util/bindSocket.h>
#include <util/ringBufferNT.h>
#include <util/controlChannel.h>
#include <producer/yaf/yafGenerator.h>

#include <stdiostream.h>
#include <fstream.h>
#include <streambuf.h>

#include <signal/toolkit/eventQueue.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

extern "C" {
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
	   }

#define __BUFFER_UNDERRUN_DETECTED            1
#define __BUFFER_UNDERRUN_NOTIFIED            2
#define __BUFFER_UNDERRUN_FALSE_DETECTED      3
#define __BUFFER_UNDERRUN_FALSE_NOTIFIED      4


class YafStream  {

 public:
  YafStream(struct YafGenerator* generator,int bufferSize);

  ~YafStream();

  // return false if underun
  int fillBuffer(AudioBuffer* chunk);

  // must be public because of thread! do not call directly!
  void readloop();



  char* getFifoCommand();
  void lockReaderThread();
  void unlockReaderThread();

  void close();
  void open();
  void clear();
  void setEOF(int leof);
  int getEOF();

  void setReaderBlock(int allow);
  int getReaderBlock();

 private:
  void start();
  void stop();
  void setWriteRing(int lWrite);

  pthread_t tr;

  pthread_mutex_t mut;
  pthread_cond_t cond;
  
  // ring-buffer 
  RingBufferNT* ringBufferNT;   // thread safe ring buffer
  struct YafGenerator* generator;
  
  int size;
  int buffUnderRunSize;     // sets the byte rate for an "underrun"
  int buffOverRunSize; 

  // file descriptor for "inStream" (Fifo!)
  BindSocket* bindSocket;
  int isShutdown;

  Buffer* fifoCommand;
  int pingNr;

  int bufferUnderrun;      // stores if we have a "buffer underrun"

  int streamCounter;       // the number of the instance of yafStream
  int lWriteToRing;        // if read data should be written into ringbuffer
  long allRead;
  int lSockCreate;
  Buffer* randomName;
  int eof;
};



#endif
