/*
  wrapper class for the compiled in toolkit
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <signal/toolkit/yafObject.h>


YafObject::YafObject() {
}


YafObject::~YafObject() {
}


void YafObject::emitEvent(unsigned char msg) {
  
  // local messages are < 127 so we cast them to a char

  emit(processEvent((char)msg));
}


/**
   This part is from the qt source.
*/

void YafObject::emitGlobalEvent(unsigned char msg) {
  YafGlobalEvent* yafGlobalEvent;
  QList<QConnection> *clist=(QList<QConnection>*)
    receivers("processEvent(char)");

  if ( !clist || signalsBlocked() )
    return;

  register QConnection *c;
  register QObject *object;
  int n=clist->count();
  int i;

  for (i=0;i<n;i++) {

    c=(QConnection*) clist->at(i);
    object = c->object();

    yafGlobalEvent=new YafGlobalEvent();
    yafGlobalEvent->setMsg((int)msg);
    kapp->postEvent(object,yafGlobalEvent);
  }

}



