/*
  a thread safe ring buffer
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef _RINGBUFFER_H
#define _RINGBUFFER_H

#include <pthread.h>

#include <iostream.h>
#include <deviceConfig/mem/memChunk.h>

extern "C" {
  #include <stdio.h>
	   }





/** 
   Note to parameter minLinBufSize in Constructor:
   <p>
   If the fillgrade is sufficient we can delivier at least
   this amount of bytes with one "fill"
   (If the fillgrade is not suffficient we can only deliever fillgrade)
   This values adresses the problem that a ring buffer cannot
   deliever linear memory the whole time(eg. if you read near the
   upper end)
   <p>
   If the requested Buffersize by the device is smaller than
   this number you can be sure that you get exactly
   your preferred buffersize. not more not less.(but
   only if the fillgrade allows this)
*/




class RingBuffer {


 public:

  RingBuffer(int ringBufferSize, int minLinBufferSize);
  virtual ~RingBuffer();

  // Writer thread can call these:

  int getWriteArea(struct MemChunk* gmem,int prefSize);
  void forwardWritePtr(int bytes);
  int waitForSpace(int minSpace);
  void exitWaitForSpace();

  
  // Reader thread these:
 
  void forwardReadPtr(int bytes);
  int getReadArea(struct MemChunk* gmem,int prefSize);
  int waitForData(int minData);
  void exitWaitForData();

  void setWaitForData(int lallow);
  int getWaitForData();

  // and the lockPos
  void forwardLockPtr(int bytes);


  // both:

  int getFillgrade();       // return how much buffer between reader/writer
  void emptyBuffer();    // frees the space between them
  int getSize();
  int getReadBytes();
  int getWriteBytes();


 private:
  void updateCanWrite();
  void updateCanRead();

  int size;
  
  int lockgrade;
  int fillgrade;
  
  char* readPos;
  char* writePos;
  char* lockPos;

  char* startPos;

  char* lastPos;
  char* eofPos;
  int canWrite;
  int canRead;

  int waitMinData;
  int waitMinSpace;

  pthread_mutex_t mut;
  pthread_cond_t dataCond;
  pthread_cond_t spaceCond;
  
  int insertBlock;
  int readBlock;
  int linAvail;

  char* minLinBuf;
  int minLinBufSize;
  int lWaitForData;
  int lWaitForSpace;

  int lAllowWaitForData;

  // statistic purpose:
  int readBytes;
  int writeBytes;
  
};

#endif

  



