/*
  a thread safe ring buffer with support for locked memory
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef _RINGBUFFERNT_H
#define _RINGBUFFERNT_H


#include <util/ringBuffer.h>
#include <deviceConfig/mem/garbageCollector.h>


#define _MAX_MEM_CHUNKS  30

/**
  The NT ringbuffer makes use of the memChunk memory. You can
  lock the memory in the ringbuffer but must make sure that
  you someday unlock it or the ringbuffer stopps working.
  <p>
  The memoryManager which is implemented is easy. It can deliver
  memChunks and forwards the lockPointer in the ringbuffer if
  the memChunk is not locked.
*/

class RingBufferNT : public RingBuffer, MemManager {

  struct MemChunk* memChunkArray[_MAX_MEM_CHUNKS];
  int lockPos;
  int freePos;
  int lockCounter;
  int canRead;

 public:

  RingBufferNT(int ringBufferSize, int minLinBufferSize);
  ~RingBufferNT();

  
  // Reader thread these:

  struct MemChunk* requestMemChunk(int preferredSize);
  

  void lockMemChunk(struct MemChunk* memChunk);
  void unlockMemChunk(struct MemChunk* memChunk);
  int overflowDanger();

};

#endif

  
