//
// /home/ms/sidplay/X11/RCS/MainDialog.h,v
//

#ifndef MainDialog_included
#define MainDialog_included

#include "MainDialogData.h"
#include "PicButton.h"

#include <qapp.h>
#include <qkeycode.h>
#include <qmenubar.h>
#include <qpushbt.h>
#include <qpopmenu.h>
#include <qtooltip.h>

class MainDialog : public MainDialogData
{
    Q_OBJECT

public:

    MainDialog
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~MainDialog();

	void invokeHelp();
	void adjustCommandButtons();
	void buttonsOff();
	void buttonsForceInitialState();
	void setPrevBtnState();
	void setNextBtnState();
	
	void showSidTuneInfo();
	void showStilInfo();
	void clearSidTuneInfo();
	void drawTime(char* timeString);
	void connectFileDialog();
	void enableWaveViewDlg(bool);

	bool isStilInfoEnabled();
	void setStilInfoEnabled(bool);
	
 protected:
	
    PicButton* prevBtn;
    PicButton* stopBtn;
    PicButton* playBtn;
    PicButton* ffBtn;
    PicButton* nextBtn;
	
	QPixmap* prevPic;
	QPixmap* stopPic;
	QPixmap* playPic;
	QPixmap* ffPic;
	QPixmap* nextPic;

	QPixmap* stop_pPic;
	QPixmap* pause_pPic;
	QPixmap* ff_pPic;
	
	QPixmap* prev_lPic;
	QPixmap* stop_lPic;
	QPixmap* play_lPic;
	QPixmap* pause_lPic;
	QPixmap* ff_lPic;
	QPixmap* next_lPic;
	
	QPixmap* prev_l_pPic;
	QPixmap* stop_l_pPic;
	QPixmap* play_l_pPic;
	QPixmap* next_l_pPic;

 private:
	
    QMenuBar *menu;
	QPopupMenu *extra;
	int waveViewID, stilID;
	
public slots:
	
	void playFile(const char*);
	void loadStilData(const char*);
	
    virtual void open();
    virtual void saveAs();
    virtual void quit();
	
    void openAudioDialog();
    void openEmulatorDialog();
    void openFilterDialog();
    void openMixerDialog();
	
	void toggleStilDialog();
    void openWaveViewDialog();

    void about();
    void aboutQt();
	
protected slots:

	virtual void done(int);
	
    void prevSongPressed();
    void prevSongReleased();
    void stopSongPressed();
    void stopSongReleased();
    void playSongPressed();
    void playSongReleased();
    void forwardSongPressed();
    void forwardSongReleased();
    void nextSongPressed();
    void nextSongReleased();

};
#endif // MainDialog_included
