/***************************************************************************
                          ksoundrecord.h  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOUNDRECORD_H
#define KSOUNDRECORD_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kprocess.h>

#include <qbitarray.h>

// forward declaration of the Ksoundrecord classes
class KsoundrecordDoc;
class KsoundrecordView;

/**
  * The base class for Ksoundrecord application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KsoundrecordView creates your center view, which is connected
  * to the window's Doc object.
  * KsoundrecordApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class KsoundrecordApp : public KTMainWindow
{
  Q_OBJECT

  friend class KsoundrecordView;

  public:
    /** construtor of KsoundrecordApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KsoundrecordApp();
    ~KsoundrecordApp();
    /** enables menuentries/toolbar items
     */
    void enableCommand(int id_);
    /** disables menuentries/toolbar items
     */
    void disableCommand(int id_);
    /** add a opened file to the recent file list and update recent_file_menu
     */

    /** opens a file specified by commandline option
     */
    void openDocumentFile(const char *_cmdl);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    KsoundrecordDoc *getDocument() const; 	
  /**  */


  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     * @see KApplication#getHelpMenu
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

  public slots:
    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);
    /** open a new application window by creating a new instance of KsoundrecordApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */

    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */

    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);
  /** record the file with use of program rec */
  void slotRec();
  /** stop recording */
  void slotStop();
  /** play wav-file */
  void slotPlay();
  /** show recordtime  */
  void slot_length_label(KProcess*, char*, int);
  /** encode temp file to mp3 */
  void slotEncode();
  /** Schow Outputlog */
  void slotViewOutput();
  /** start Mixer */
  void slotMixer();
  /** encode exit */
  void slotmp3stop();
  /** Play exit */
  void slotplaystop();
  /** record exit */
  void slotrecstop();
  /** Options Dialog */
  void slotOptions();

  /** record,mp3 ... Options */
  void slot_readMyOptions();
  void slot_saveMyOptions();
  /** select stereo_mode in dialog */
  void slot_stereo(int);
  /**  */
  void slot_prog(int);
  /**  */
  void slot_prog_args();
  /**  */
  void slot_rec_samplerate(int);
  /**  */
  void slot_rec_bits(int);
  /**  */
  void slot_rec_stereo(int);
  /**  */
  void slot_mp3_play();
  /**  */
  void slot_bitrate_changed(int);
  /**  */
  void slot_background1();
  void slot_background2();
  void slot_background3();
  void slot_background4();
  void slot_background5();
  /**  */
  void slot_no_background();
  /**  */
  void slot_ask_opt(int);
  /**  */
  void slot_vbr_changed(int);
  /**  */
  void slot_kill_sox(KProcess*, char*, int);
  /**  */
  void slot_view_filelist(QStrList);
  void slot_hide_filelist();
  /** add filenames to filelist */
  void slot_add_filesnames();
  /** remove files from filelist */
  void slot_remove_files();

  private:
    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** help_menu contains all items of the menubar entry "Help" */
		QPopupMenu *optionMenu;
    /** help_menu contains all items of the menubar entry "Options" */
    QPopupMenu *helpMenu;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KsoundrecordView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KsoundrecordDoc *doc;

public: // Public attributes
  KProcess* recProc;
  /** play */
  KProcess* playProc;
  /**  */
  KProcess* mixProc;
  /** encode */
  KProcess* mp3Proc;
  /** play mp3 */
  KProcess* mp3playProc;
  KProcess* killSoxProc;
  KShellProcess* findsoxProc;

  /** filename to record */
  QStrList rec_file;
  QStrList wav_file;
  int wav_nr;
  QList <bool> is_mp3;
  QList <bool> is_work;
  /** mp3 filename */
  QStrList mp3_file;
  int mp3_nr;
  int background;
  QString hilfe;
  QString stereo;
  QString bitrate;
  QString vbr_rate;
  /** mp3 arguments */
  QString mp3_args[15];
  /** rec arguments */
  QString rec_args[15];

  int record_prog;
  int rec_samplerate;
	int rec_bits;
	int rec_channels;
	int ask;

};

#endif // KSOUNDRECORD_H
