/***************************************************************************
                          carray.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __CArray__
#define __CArray__

#include <qarray.h>

template<class type> class CArray : public QArray<type>
{
public:
	CArray(){};
	CArray(int size); 
	CArray( const CArray<type> &a);
	~CArray(){};
	CArray<type> &operator=(const CArray<type> &a)
				{ return assign(a); };
	type *data()    const	{ return (type *)QArray<type>::data(); }
	uint  nrefs()   const	{ return QArray<type>::nrefs(); }
	uint  size()    const	{ return QArray<type>::size(); }
	bool  isEmpty() const	{ return QArray<type>::size() == 0; }
	bool  isNull()  const	{ return QArray<type>::data() == 0; }
	bool  resize( uint size )	{ return QArray<type>::resize(size); }
	bool  truncate( uint pos )	{ return QArray<type>::resize(pos); }
	bool  fill( const type &v, int size=-1 )
		{ return QArray<type>::fill(v,size ); }
	void  detach()		{ QArray<type>::detach(); }
	CArray<type>   copy() const
		{ CArray<type> tmp; return tmp.duplicate(*this); }
	CArray<type>& assign( const CArray<type>& a )
		{ return (CArray<type>&)QArray<type>::assign(a); }
	CArray<type>& assign( const type *a, uint n )
		{ return (CArray<type>&)QArray<type>::assign(a,n); }
	CArray<type>& duplicate( const CArray<type>& a )
		{ return (CArray<type>&)QArray<type>::duplicate(a); }
	CArray<type>& duplicate( const type *a, uint n )
		{ return (CArray<type>&)QArray<type>::duplicate(a,n); }
	CArray<type>& setRawData( const type *a, uint n )
		{ return (CArray<type>&)QArray<type>::setRawData(a,n); }
	void resetRawData( const type *a, uint n )
		{ QArray<type>::resetRawData(a,n); }
	int	 find( const type &d, uint i=0 ) const
		{ return QArray<type>::find(d,i); }
	int	 contains( const type &d ) const
		{ return QArray<type>::contains(d); }
	type& operator[]( int i ) const
		{ return QArray<type>::at(i); }
	type& at( uint i ) const
		{ return QArray<type>::at(i); }
	operator const type*() const { return (const type *)QArray<type>::data(); }
	bool operator==( const CArray<type> &a ) const { return isEqual(a); }
	bool operator!=( const CArray<type> &a ) const { return !isEqual(a); }

	bool	insert(CArray<type>*,uint index);
	bool	insert(type*,uint n,uint index);

	bool	replace(CArray<type>*,uint index);
	bool	replace(type*,uint n,uint index);

	bool	cut(uint index,uint n);
	bool	del(uint index);

	bool	get(CArray<type>*,uint index,uint n);
	bool	get(type*,uint index,uint n);

	bool	move(uint d,uint s,int n)
	{
		if(n <= 0) return false;

		move(d,s,(uint)n);

		return true;
	};
	bool	move(uint d,uint s ,uint n)
	{
		if(d * sizeof(type) > size() ||s * sizeof(type) > size())
			return false;
		memmove(data() + d * sizeof(type),data() + s * sizeof(type),n * sizeof(type));

		return true;
	};

protected:
	bool	move(type*,type*,uint);
};

template<class type>
CArray<type>::CArray(int size) : QArray<type>(size)
{
}

template<class type>
CArray<type>::CArray( const CArray<type> &a) : QArray<type>(a)
{
}

template<class type>
bool	CArray<type>::insert(CArray<type> *a,uint index)
{
	if(resize(size() + a->size() * sizeof(type)))
	{
		type	*d;

		d = data();
		move(d + index + a->size(),d + index,a->size());
		move(d + index,a->data(),a->size());

		return TRUE;
	}
	return FALSE;
}

template<class type>
bool	CArray<type>::insert(type *a,uint n,uint index)
{
	if(resize(size() + n * sizeof(type)))
	{
		type	*d;

		d = data();
		move(d + index + n,d + index,n);
		move(d + index,a,n);

		return TRUE;
	}
	return FALSE;
}

template<class type>
bool	CArray<type>::replace(CArray<type> *a,uint index)
{
	type	*d;

	d = data();
	move(d + index,a->data(),a->size());

	return TRUE;
}

template<class type>
bool	CArray<type>::replace(type *a,uint n,uint index)
{
	type	*d;

	d = data();
	move(d + index,a,n);

	return TRUE;
}

template<class type>
bool	CArray<type>::cut(uint index,uint n)
{
	type	*d;

	d = data();
	move(d + index,d + index + n,size() - index - n);

	return resize(size() - n);
}

template<class type>
bool	CArray<type>::del(uint index)
{
	return cut(index,1);
}

template<class type>
bool	CArray<type>::get(CArray<type>*a,uint index,uint n)
{
	if(a->resize(n))
	{
		type	*d;

		d = a->data();
		move(d,data() + index,n);

		return TRUE;
	}
	return FALSE;
}

template<class type>
bool	CArray<type>::get(type *d,uint index,uint n)
{
	move(d,data() + index,n);

	return TRUE;
}

/*
template<class type>
bool	CArray<type>::move(uint d,uint s,int n)
{
	if(n <= 0) return FALSE;

	move(d,s,(uint)n);

	return TRUE;
}

template<class type>
bool	CArray<type>::move(uint d,uint s,uint n)
{
	memmove(data() + d * sizeof(type),data() + s * sizeof(type),n * sizeof(type));

	return TRUE;
}
*/

template<class type>
bool	CArray<type>::move(type *d,type *s,uint n)
{
	memmove(d,s,n * sizeof(type));

	return TRUE;
}




#endif

