/***************************************************************************
                          ksoundsysdoc.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 01:22:14 CET 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include <ksoundsysdoc.h>
#include "ksoundsys.h"
#include "ksoundsysview.h"
#include "kssdialogs.h"
#include "csample.h"
#include "afx.h"


KSoundSysDoc::KSoundSysDoc(QWidget *parent, const char* name):QObject(parent, name)
{
}

KSoundSysDoc::~KSoundSysDoc()
{
}

void KSoundSysDoc::setView(KSoundSysView* m_pView)
{
	m_view = m_pView;
	connect(this,SIGNAL(signalMode(KSoundWidget::Mode)),m_pView,SLOT(setMode(KSoundWidget::Mode)));
	connect(this,SIGNAL(signalBusy(bool)),m_pView,SLOT(setBusy(bool)));
}

void KSoundSysDoc::removeView(KSoundSysView* m_pView)
{
}

const QString& KSoundSysDoc::getPathName() const
{
	return m_path;
}

void KSoundSysDoc::slotUpdateAllViews(KSoundSysView* pSender)
{
	if(m_view)
	{
		m_view->slotUpdate();
		m_view->paint();
	}
}

void KSoundSysDoc::pathName( const char* path_name)
{
	m_path=path_name;
}

void KSoundSysDoc::title( const char* title)
{
	m_title=title;
}

const QString& KSoundSysDoc::getTitle() const
{
	return m_title;
}

bool KSoundSysDoc::saveModified()
{
	if(b_modified)
	{
		KSoundSysApp* win=(KSoundSysApp*) parent();
  	int want_save = KMsgBox::yesNoCancel(win,
  									i18n("Warning"),	i18n("The current file has been modified.\nDo you want to save it?"));
   	switch(want_save)
    {
    	case 1:
    		if(m_title == "Untitled")
    			win->slotFileSaveAs();
    		else
	     		saveDocument(getPathName()+getTitle());
       	
       	deleteContents();
        return true;
        break;
  		case 2:
    		setModified(false);
      	deleteContents();
  			return true;
  			break;	
  		case 3:
  			return false;
  			break;
  		default:
  			return false;
  			break;
  	}
	}
	else
		return true;

}

void KSoundSysDoc::closeDocument()
{
	deleteContents();
}

bool KSoundSysDoc::newDocument()
{
	
	/////////////////////////////////////////////////
	// TODO: Add your document initialization code here
	/////////////////////////////////////////////////
	b_modified=false;
	m_path=QDir::homeDirPath();
	m_title="Untitled";
	m_sample.clear();
	m_sample.addChannel();
	m_sample.setRate(44100);
	slotUpdateAllViews(0);
	
	return true;
}

bool KSoundSysDoc::newFormatedDocument()
{
	uint			nchannel,i;
	newdialog	nd(0,i18n("New Sampleformat"),44100,1,2);
	
	nd.show();
		
	if(nd.result())
	{
		/////////////////////////////////////////////////
		// TODO: Add your document initialization code here
		/////////////////////////////////////////////////
		b_modified=false;
		m_path=QDir::homeDirPath();
		m_title="Untitled";
		m_sample.clear();
		nchannel = nd.getNChannel();
		for(i = 0;i < nchannel;i++)
			m_sample.addChannel();
		m_sample.setRate(MAX(0,MIN(48000,nd.getSampleRate())));
		switch(nd.getType())
		{
			case 0:
				m_sample.convertToType8();
			break;
			case 1:
				m_sample.convertToType16();
			break;
			case 2:
				m_sample.convertToType32();
			break;
			case 3:
				m_sample.convertToTypeFL();
			break;
			case 4:
				m_sample.convertToTypeDB();
			break;
			default:
				m_sample.convertToType16();
			break;
		}
	}	
	slotUpdateAllViews(0);
	
	return true;
}

bool KSoundSysDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	int				error;
	
	m_title=fileInfo.fileName();
	m_path=fileInfo.absFilePath();	
	/////////////////////////////////////////////////
	// TODO: Add your document opening code here
	/////////////////////////////////////////////////
	error = m_sample.loadWave(filename);
	slotUpdateAllViews(0);
	m_view->paint();
	
	b_modified=false;
	return (error == 0);
}

bool KSoundSysDoc::saveDocument(const char* filename, const char* format)
{

	/////////////////////////////////////////////////
	// TODO: Add your document saving code here
	/////////////////////////////////////////////////
	m_sample.saveWave(filename);

	b_modified=false;
	return true;
}

void KSoundSysDoc::deleteContents()
{
	/////////////////////////////////////////////////
	// TODO: Add implementation to delete the document contents
	/////////////////////////////////////////////////
	m_sample.clear();

}

/**  */
CSample* KSoundSysDoc::sample()
{
	return &m_sample;
}

/**  */
void KSoundSysDoc::changeFormat()
{
	int									sr = sample()->getRate();
	//int								c = kswp->getSample()->getNChannel();
	int									t = 0;
	QString							qstr;
	//char								str[24];

	if(sample()->isType8()) t = 0;
	if(sample()->isType16()) t = 1;
	if(sample()->isType32()) t = 2;
	if(sample()->isTypeFL()) t = 3;
	if(sample()->isTypeDB()) t = 4;

	formatdialog fd(0,"Format",sr,t);

	fd.show();

	if(fd.result())
	{
		sr = fd.getSampleRate();
		t = fd.getType();

		emit signalBusy(true);
		
		//disableMenu();

		sample()->convertToTypeDB();
		if(t == 0) sample()->convertTypeDBToType8();
		if(t == 1) sample()->convertTypeDBToType16();
		if(t == 2) sample()->convertTypeDBToType32();
		if(t == 3) sample()->convertTypeDBToTypeFL();

		sample()->setRate(sr);

		emit signalBusy(false);
//		enableMenu();

//		stbar->changeItem(i18n("Format changed"),1);

		setModified(true);
				
		//kswp->paint();

/*
		qstr = i18n("Time: ");
		qstr += sprinttf("%h:%2m:%2s.%3u",
			(int)((double)kswp->getSample()->getLength() /
			       (double)kswp->getSample()->getRate() * 1000));
		stbar->changeItem(qstr,3);
		qstr = i18n("Samples: ");
		sprintf(str,"%12i",kswp->getSample()->getLength());
		qstr += str;
		stbar->changeItem(qstr,2);
		switch(kswp->getSample()->getNChannel())
		{
			case 1:
				stbar->changeItem(" Mono",4);
			break;
			case 2:
				stbar->changeItem("Stereo",4);
			break;
			case 4:
				stbar->changeItem("Quadro",4);
			break;
			default:
				sprintf(str,"%i",kswp->getSample()->getNChannel());
				stbar->changeItem(str,4);
		}
		if(kswp->getSample()->isType8()) stbar->changeItem(i18n("Int8"),5);
		if(kswp->getSample()->isType16()) stbar->changeItem(i18n("Int16"),5);
		if(kswp->getSample()->isType32()) stbar->changeItem(i18n("Int32"),5);
		if(kswp->getSample()->isTypeFL()) stbar->changeItem(i18n("FLT"),5);
		if(kswp->getSample()->isTypeDB()) stbar->changeItem(i18n("DBL"),5);
*/
	}
	//kswp->setSample();
}

/**  */
void KSoundSysDoc::insertSilence()
{
	QString		qstr;
	//char		str[24];
	timedialog	td(0,"Insert Silence");
	long long		count,pointer;

	td.show();

	if(td.result())
	{
		count = (long long)((double)sample()->getRate() * td.getSeconds());

		pointer = m_view->getPointer();
		
		if(pointer < 0) pointer = 0;
		if(pointer > (long long)sample()->getLength())
		{
			pointer = sample()->getLength();
		}

		emit signalBusy(true);
		//disableMenu();

		CSample		ts(sample()->getNChannel(),sample()->getType(),count);
		//ts.equalize(kswp->getSample());
		//ts.resize(l);
		sample()->insert(pointer,ts.getLength(),&ts);

		emit signalBusy(false);
		//enableMenu();

/*
		stbar->changeItem(stloc("Silence inserted"),1);

		qstr = stloc("Time: ");
		qstr += sprinttf("%h:%2m:%2s.%3u",
			(int)((double)kswp->getSample()->getLength() /
			       (double)kswp->getSample()->getRate() * 1000));
		stbar->changeItem(qstr,3);
		qstr = stloc("Samples: ");
		sprintf(str,"%12i",kswp->getSample()->getLength());
		qstr += str;
		stbar->changeItem(qstr,2);

		changed = TRUE;
		//kswp->setZoom(100);
		//kswp->setDisplayStart(0);
		kswp->paint();
*/
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::insertSinus()
{
	QString		qstr;
	//char		str[24];
	timedialog	td(0,"Insert Sinus");
	long long		count,pointer;
	int					c,i;

	td.show();

	if(td.result())
	{
		count = (long long)((double)sample()->getRate() * td.getSeconds());

		pointer = m_view->getPointer();
		
		if(pointer < 0) pointer = 0;
		if(pointer > (long long)sample()->getLength())
		{
			pointer = sample()->getLength();
		}

		emit signalBusy(true);
		//disableMenu();

		CSample		ts(sample()->getNChannel(),sample()->getType(),count);
		//ts.equalize(kswp->getSample());
		//ts.resize(l);
		
		for(i = 0;i < (int)ts.getLength();i++)
		{
			double	d;
			
			d = sin((double)i / ts.getLength() * M_PI * 2);
			for(c = 0;c < ts.getNChannel();c++)
			{
				ts.set(c,i,1,&d);
			}
		}
		sample()->insert(pointer,ts.getLength(),&ts);

		emit signalBusy(false);
		//enableMenu();

/*
		stbar->changeItem(stloc("Silence inserted"),1);

		qstr = stloc("Time: ");
		qstr += sprinttf("%h:%2m:%2s.%3u",
			(int)((double)kswp->getSample()->getLength() /
			       (double)kswp->getSample()->getRate() * 1000));
		stbar->changeItem(qstr,3);
		qstr = stloc("Samples: ");
		sprintf(str,"%12i",kswp->getSample()->getLength());
		qstr += str;
		stbar->changeItem(qstr,2);

		changed = TRUE;
		//kswp->setZoom(100);
		//kswp->setDisplayStart(0);
		kswp->paint();
*/
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::insertSquare()
{
	QString		qstr;
	//char		str[24];
	timedialog	td(0,"Insert Square");
	long long		count,pointer;
	int					c,i;

	td.show();

	if(td.result())
	{
		count = (long long)((double)sample()->getRate() * td.getSeconds());

		pointer = m_view->getPointer();
		
		if(pointer < 0) pointer = 0;
		if(pointer > (long long)sample()->getLength())
		{
			pointer = sample()->getLength();
		}

		emit signalBusy(true);
		//disableMenu();

		CSample		ts(sample()->getNChannel(),sample()->getType(),count);
		//ts.equalize(kswp->getSample());
		//ts.resize(l);
		
		for(i = 0;i < (int)ts.getLength();i++)
		{
			double	d;
			
			d = (i < ((int)ts.getLength() / 2) ? 1 : -1);
			for(c = 0;c < ts.getNChannel();c++)
			{
				ts.set(c,i,1,&d);
			}
		}
		sample()->insert(pointer,ts.getLength(),&ts);

		emit signalBusy(false);
		//enableMenu();

/*
		stbar->changeItem(stloc("Silence inserted"),1);

		qstr = stloc("Time: ");
		qstr += sprinttf("%h:%2m:%2s.%3u",
			(int)((double)kswp->getSample()->getLength() /
			       (double)kswp->getSample()->getRate() * 1000));
		stbar->changeItem(qstr,3);
		qstr = stloc("Samples: ");
		sprintf(str,"%12i",kswp->getSample()->getLength());
		qstr += str;
		stbar->changeItem(qstr,2);

		changed = TRUE;
		//kswp->setZoom(100);
		//kswp->setDisplayStart(0);
		kswp->paint();
*/
		setModified(true);
	}
}


/**  */
void KSoundSysDoc::copy(CSample &cnps)
{
	uint		s,e,l,r;

	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	l = e - s;

	cnps.equalize(sample());
	//if(cnpsample->isType8()) printf("ksoundsys: copy: cnpsample now type I8\n");
	//if(cnpsample->isType16()) printf("ksoundsys: copy: cnpsample now type I16\n");
	//if(cnpsample->isTypeDB()) printf("ksoundsys: copy: cnpsample now type DB\n");
	r = sample()->get(s,l,cnps);
	
	m_view->paint();
	setModified(true);
}

/**  */
void KSoundSysDoc::cut(CSample &cnps)
{
	uint		s,e,l;
//	QString		qstr;
//	char		str[24];

	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	l = e - s;

	cnps.equalize(sample());
	//if(cnpsample->isType8()) printf("ksoundsys: cut: cnpsample now type I8\n");
	//if(cnpsample->isType16()) printf("ksoundsys: cut: cnpsample now type I16\n");
	//if(cnpsample->isTypeDB()) printf("ksoundsys: cut: cnpsample now type DB\n");

	sample()->cut(s,l,cnps);
	//kswp->setDisplayStart(kswp->getDisplayStart() - 1);
	m_view->setSelectionStart(-1);
	m_view->setSelectionEnd(-1);
	m_view->paint();

/*
	qstr = stloc("Time: ");
	qstr += sprinttf("%h:%2m:%2s.%3u",
		(int)((double)kswp->getSample()->getLength() /
		       (double)kswp->getSample()->getRate() * 1000));
	stbar->changeItem(qstr,3);
	qstr = stloc("Samples: ");
	sprintf(str,"%12i",kswp->getSample()->getLength());
	qstr += str;
	stbar->changeItem(qstr,2);
*/
	setModified(true);
}

/**  */
void KSoundSysDoc::paste(CSample &cnps)
{
	uint		s;
//	QString		qstr;
//	char		str[24];

//	s = m_view->getSelectionStart();
	s = m_view->getPointer();

	sample()->insert(s,cnps);
	printf("ksoundsys: paste: insert(%i,%i,cnpsample)\n",s,cnps.getLength());
	m_view->setSelectionStart(-1);
	m_view->setSelectionEnd(-1);
	m_view->paint();
	//m_view->setZoom(100);
	//m_view->setDisplayStart(0);

/*
	qstr = stloc("Time: ");
	qstr += sprinttf("%h:%2m:%2s.%3u",
		(int)((double)kswp->getSample()->getLength() /
		       (double)kswp->getSample()->getRate() * 1000));
	stbar->changeItem(qstr,3);
	qstr = stloc("Samples: ");
	sprintf(str,"%12i",kswp->getSample()->getLength());
	qstr += str;
	stbar->changeItem(qstr,2);
*/
	setModified(true);
}


/**  */
void KSoundSysDoc::optimizeVolume()
{
	int		s,e,l;
	CAFX	afx;

	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	l = e - s;
	if(s < 0 || e < 0)
	{
		s = 0;
		l = sample()->getLength();
	}

	m_view->setBusy(true);
//	disableMenu();

	afx.volume(sample(),s,l);

//	enableMenu();
	m_view->setBusy(false);

//	stbar->changeItem(stloc("Optimized Volume"),1);

	m_view->paint();
	setModified(true);
}

/**  */
void KSoundSysDoc::optimizeDCOffset()
{
	int		s,e,l;
	CAFX	afx;

	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	l = e - s;
	if(s < 0 || e < 0)
	{
		s = 0;
		l = sample()->getLength();
	}

	 m_view->setBusy(true);
//	disableMenu();

	afx.optimizeDCOffset(sample(),s,l);

//	enableMenu();
	m_view->setBusy(false);

//	stbar->changeItem(stloc("Optimized DC-Offset"),1);

	m_view->paint();
	setModified(true);
}


/**  */
void KSoundSysDoc::volume()
{
	int				s,e,l;
	double		vol;
	voldialog	vold(0,"Volume");
	CAFX			afx;
	
	vold.show();

	if(vold.result())
	{
		vol = vold.getVol();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.volume(sample(),vol,s,l);

//		enableMenu();
 		m_view->setBusy(false);

//		stbar->changeItem(stloc("Volume-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::changeDCOffset()
{
}

/**  */
void KSoundSysDoc::fuzz()
{
	int		s,e,l;
	fuzzdialog	fuzzd(0,"Fuzz");
	double		vol,cut;
	CAFX			afx;

	fuzzd.show();

	if(fuzzd.result())
	{
		vol = fuzzd.getVolume();
		cut = fuzzd.getCut();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.fuzz(sample(),vol,cut,1,s,l);

//		enableMenu();
 		m_view->setBusy(false);

//		stbar->changeItem(stloc("Fuzz-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::noisegate()
{
	int							s,e,l;
	double					treshhold;
	noisegatedialog	ngd(0,"NoiseGate");
 	CAFX			afx;

	ngd.show();

	if(ngd.result())
	{
		treshhold = ngd.getTreshhold();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

 		m_view->setBusy(true);
//		disableMenu();

		afx.noiseGate(sample(),treshhold,s,l);

//		enableMenu();
 		m_view->setBusy(false);

//		stbar->changeItem(stloc("NoiseGate-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::hullcurve()
{
	int		s,e,l;
	CAFX			afx;

	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	l = e - s;
	if(s < 0 || e < 0)
	{
		s = 0;
		l = sample()->getLength();
	}

		m_view->setBusy(true);
//	disableMenu();

	afx.hull(sample(),s,l);

//	enableMenu();
		m_view->setBusy(false);

//	stbar->changeItem(stloc("Hullcurve"),1);

	m_view->paint();
	setModified(true);
}


/**  */
void KSoundSysDoc::compress()
{
	int							s,e,l;
	double					level;
 	compressdialog	cd(0,"Compress");
	CAFX			afx;

	cd.show();

	if(cd.result())
	{
		level = cd.getLevel();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.compress(sample(),level,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Compress-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::expand()
{
	int							s,e,l;
	double					level;
	compressdialog	cd(0,"Expand");
 	CAFX						afx;

	cd.show();

	if(cd.result())
	{
		level = cd.getLevel();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.expand(sample(),level,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Expand-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}


/**  */
void KSoundSysDoc::echo()
{
	int					s,e,l;
	double			vol,delay,release;
	echodialog	echod(0,"Echo");
	CAFX				afx;

	echod.show();

	if(echod.result())
	{
		delay = echod.getDelay();
		vol = echod.getVolume();
		release = echod.getRelease();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.echo(sample(),delay,vol,release,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Echo-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::highpass()
{
	int					s,e,l;
	double			r,c;
	dphpdialog	dphpd(0,"Highpass");
	CAFX				afx;

	dphpd.show();

	if(dphpd.result())
	{
		r = dphpd.getR();
		c = dphpd.getC();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.highpass(sample(),c,r,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Highpass-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::blur()
{
	int					s,e,l;
 	blurdialog	bd(0,"Blur");
 	CAFX				afx;
 	double			size;

	bd.show();

	if(bd.result())
	{
		size = bd.getSize();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.blur(sample(),size,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Deeppass-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::deeppass()
{
	int					s,e,l;
	double			r,c;
	dphpdialog	dphpd(0,"Deeppass");
 	CAFX				afx;

	dphpd.show();

	if(dphpd.result())
	{
		r = dphpd.getR();
		c = dphpd.getC();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.deeppass(sample(),c,r,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Deeppass-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::distort()
{
	int							s,e,l;
	QArray<double>	points;
	distdialog			distd(0,"Distortion");
	CAFX						afx;
	bool						sym;

	distd.show();

	if(distd.result())
	{
		points = distd.getPoints();
		sym = distd.symmetric();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.distortion(sample(),points,sym,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Distortion-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::envelope()
{
	int							s,e,l;
	QArray<double>	points;
 	envdialog				envd(0,"Envelope");
 	CAFX						afx;

	envd.show();

	if(envd.result())
	{
		points = envd.getPoints();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

		afx.volume(sample(),points,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Envelope-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::pitchshift()
{
	int								s,e,l;
	double						shift;
 	multiplierdialog	psd("ShiftPitch");
 	CAFX							afx;

	psd.show();

	if(psd.result())
	{
		shift = psd.getMultiplier();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

//		afx.shiftpitch(sample(),shift,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Envelope-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

/**  */
void KSoundSysDoc::takepitch()
{
	int								s,e,l;
	int								pn;
 	multiplierdialog	psd("TakePitch");
 	CAFX							afx;

	psd.show();

	if(psd.result())
	{
		pn = (int)psd.getMultiplier();

		s = m_view->getSelectionStart();
		e = m_view->getSelectionEnd();
		l = e - s;
		if(s < 0 || e < 0)
		{
			s = 0;
			l = sample()->getLength();
		}

		m_view->setBusy(true);
//		disableMenu();

//		afx.takepitch(sample(),pn,s,l);

//		enableMenu();
		m_view->setBusy(false);

//		stbar->changeItem(stloc("Envelope-filtered"),1);

		m_view->paint();
		setModified(true);
	}
}

void	KSoundSysDoc::timerEvent(QTimerEvent *te)
{
	if(te == 0) return;
	
	if(sample()->playing())
	{
		int	playpos;
		
		playpos = sample()->currentPlayPos();
		sample()->playbackevent();
		
		m_view->setDisplayCenter(playpos);
		m_view->setPointer(playpos);
	}
	else
	{
		stop();
	}
}

/**  */
void KSoundSysDoc::play()
{
	int		s,e,t;

	killTimers();	
	sample()->stop();
	
	s = m_view->getSelectionStart();
	e = m_view->getSelectionEnd();
	if(s < 0 || e < 0)
	{
		s = 0;
		e = sample()->getLength();
	}

	t = sample()->getRate() / 20; // 50 milli seconds
	
	sample()->setWriteSamples(t);
	sample()->playback((uint)s,(uint)e);

//	Maudio->setItemEnabled(mid[20],FALSE);
//	Maudio->setItemEnabled(mid[21],TRUE);
//	Maudio->setItemEnabled(mid[22],TRUE);
//	Maudio->setItemEnabled(mid[23],FALSE);

	t = sample()->bufferSize() * 950 // 950 milli seconds
		/ (sample()->getRate()
		   * (sample()->isType8() ? 1 : 2)
		   * (sample()->isMono() ? 1 : 2));
	
	startTimer(50 - 5); // 50 milli seconds - 5 for overhead
}

/**  */
void KSoundSysDoc::stop()
{
	killTimers();	
	sample()->stop();

//	Maudio->setItemEnabled(mid[20],TRUE);
//	Maudio->setItemEnabled(mid[21],FALSE);
//	Maudio->setItemEnabled(mid[22],FALSE);
//	Maudio->setItemEnabled(mid[23],TRUE);
}

/**  */
void KSoundSysDoc::pause()
{
}

/**  */
void KSoundSysDoc::record()
{
}

