/***************************************************************************
                          ksoundwidgetpro.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "ksoundwidgetpro.h"

#include <qpixmap.h>

#include <stdlib.h>

KSoundWidgetPro::KSoundWidgetPro(QWidget *parent) :
	QWidget(parent,NULL)
{
	nchannel = 0;

	createWidgets();
}

KSoundWidgetPro::KSoundWidgetPro(QWidget *parent,CSample *s) :
	QWidget(parent,NULL)
{
	nchannel = s->getNChannel();

	createWidgets(s);
}

KSoundWidgetPro::~KSoundWidgetPro()
{
}

void	KSoundWidgetPro::createWidgets(CSample *s)
{
	int		w,h,t;
	QPixmap		&pi = pm_zoom_in;
	QPixmap		&po = pm_zoom_out;
	QString		str;

	w = width();
	h = height();

	qsb = new QScrollBar(this);

	qsb->setOrientation(QScrollBar::Horizontal);

	ktb = new Timebar(this);
	if(s)
	{
		ktb->setRangeMilliSeconds(0,100000);
		ktb->setStopMarkMilliSeconds((long long)s->getLength() * 1000 / (long long)s->getRate());
	}
	else
	{
		ktb->setRangeMilliSeconds(0,0);
		ktb->setStopMarkMilliSeconds(-1);
	}
//	ktb->setMinStep(1); // 1

	if(s)
		ksw = new KSoundWidget(this,s);
	else
		ksw = new KSoundWidget(this);

	//printf("rate=%i LINE %i\n",ksw->getRate(),__LINE__);
	//printf("rate=%i LINE %i\n",s->getRate(),__LINE__);

	ksw->setMode(KSoundWidget::Select);

	str = KApplication::kde_icondir() + "/kss_zoom_in.xpm";
	//printf("%s\n",str.data());
	pm_zoom_in = QPixmap(str);
	zoom_in = new QPushButton(this);
	zoom_in->setPixmap(pi);

	str = KApplication::kde_icondir() + "/kss_zoom_out.xpm";
	//printf("%s\n",str.data());
	pm_zoom_out = QPixmap(str);
	zoom_out = new QPushButton(this);
	zoom_out->setPixmap(po);

	nchannel = ksw->getSample()->getNChannel();
	ksb.resize(2 * nchannel);
	// printf("nchannel:%i\n",ksw->getNChannel());
	// printf("nchannel:%i\n",s->getNChannel());
	for(t = 0; t < nchannel;t++)
	{
		ksb[t * 2] = new KScaleBar(this,LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setMode(LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setRange(1,1);
		ksb[t * 2]->setNMarks(5);
		ksb[t * 2]->setFormatString("%1.1f");

		ksb[t * 2 + 1] = new KScaleBar(this,RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setMode(RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setRange(1,1);
		ksb[t * 2 + 1]->setNMarks(5);
		ksb[t * 2 + 1]->setFormatString("%1.1f");
	}
	

	connect(qsb,SIGNAL(valueChanged(int)),SLOT(changedScroll(int)));
	connect(ksw,SIGNAL(changedDisplayStart(int)),SLOT(changedDispStart(int)));
	connect(ksw,SIGNAL(changedDisplayZoom(int)),SLOT(changedDispZoom(int)));
	connect(zoom_in,SIGNAL(released()),SLOT(clickedZoomIn()));
	connect(zoom_out,SIGNAL(released()),SLOT(clickedZoomOut()));
	connect(ksw,SIGNAL(gotDndURL(char*,int)),SLOT(gotDndURL(char*,int)));
}

void	KSoundWidgetPro::layout()
{
	int		w,h,t;

	w = width();
	h = height();

	ksw->QWidget::move(32,18);
	ksw->resize(w - 64,h - 16 - 18);

	qsb->move(0,h - 16);
	qsb->resize(w - 32,16);

	ktb->move(32,0);
	ktb->resize(w - 32,18);

	zoom_in->move(w - 32,h - 16);
	zoom_in->resize(16,16);

	zoom_out->move(w - 16,h - 16);
	zoom_out->resize(16,16);

	if(ksw->getDisplayZoom() > 0)
		qsb->setRange(0,MAX(0,(int)ksw->getSample()->getLength()
				/ ksw->getDisplayZoom() 
				- ksw->width()));

	printf("nchannel:%i\n",ksw->getSample()->getNChannel());
	for(t = 0; t < ksw->getSample()->getNChannel();t++)
	{
		ksb[t * 2]->move(0,18 + t * (h - 16 - 18) / ksw->getSample()->getNChannel());
		ksb[t * 2]->resize(32,(h - 16 - 18) / ksw->getSample()->getNChannel());
		ksb[t * 2 + 1]->move(w - 32,18 + t * (h - 16 - 18)  / ksw->getSample()->getNChannel());
		ksb[t * 2 + 1]->resize(32,(h - 16 - 18) / ksw->getSample()->getNChannel());
	}
}

void	KSoundWidgetPro::paintEvent(QPaintEvent *pe)
{
	long long		min,max,rate,time;

	if(pe == 0) return;

	layout();

	rate = ksw->getSample()->getRate();
	if(rate)
	{
		min = (long long)ksw->screen2sample(0) * 1000000 / rate;
		max = (long long)ksw->screen2sample(ktb->width()) * 1000000 / rate;
		time = (long long)ksw->getSample()->getLength() * 1000000 / rate;
		ktb->setStopMarkMicroSeconds(time);
	}
	else
		min = max = 0;
	ktb->setRangeMicroSeconds(min,max);
}

void	KSoundWidgetPro::paint()
{
	long long		min,max,rate,time;

	layout();
	rate = ksw->getSample()->getRate();
	if(rate)
	{
		min = (long long)ksw->screen2sample(0) * 1000000 / rate;
		max = (long long)ksw->screen2sample(ktb->width()) * 1000000 / rate;
		time = (long long)ksw->getSample()->getLength() * 1000000 / rate;
		ktb->setStopMarkMicroSeconds(time);
	}
	else
		min = max = 0;
	ktb->setRangeMicroSeconds(min,max);

	ksw->draw();
}

void	KSoundWidgetPro::changedScroll(int v)
{
	int		i;

	i = v * (1 << ksw->getDisplayZoom());
	ksw->setDisplayStart(i);
}

void	KSoundWidgetPro::changedDispStart(int v)
{
	int					i;
	long long		min,max,rate,time;

	i = v / (1 << ksw->getDisplayZoom());
	qsb->setValue(i);

	rate = ksw->getSample()->getRate();
	if(rate)
	{
		min = (long long)ksw->screen2sample(0) * 1000000 / rate;
		max = (long long)ksw->screen2sample(ktb->width()) * 1000000 / rate;
		time = (long long)ksw->getSample()->getLength() * 1000000 / rate;
		ktb->setStopMarkMicroSeconds(time);
	}
	else
		min = max = 0;
	ktb->setRangeMicroSeconds(min,max);
}

void	KSoundWidgetPro::changedDispZoom(int v)
{
	long long		min,max,rate;

	qsb->setRange(0,MAX(0,(int)ksw->getSample()->getLength() / (1 << v) - ksw->width() + KSW_NAREA));
	changedDispStart(ksw->getDisplayStart());

	rate = ksw->getSample()->getRate();
	if(rate)
	{
		min = (long long)ksw->screen2sample(0) * 1000000 / rate;
		max = (long long)ksw->screen2sample(ktb->width()) * 1000000 / rate;
		ktb->setStopMarkMicroSeconds((long long)ksw->getSample()->getLength() * 1000000 / rate);
	}
	else
		min = max = 0;
	ktb->setRangeMicroSeconds(min,max);
}

void	KSoundWidgetPro::clickedZoomIn()
{
	ksw->setDisplayZoom(ksw->getDisplayZoom() - 1);
}

void	KSoundWidgetPro::clickedZoomOut()
{
	ksw->setDisplayZoom(ksw->getDisplayZoom() + 1);
}

void	KSoundWidgetPro::gotDndURL(char *url,int pos)
{
	emit gotURL(url,pos);
}

void	KSoundWidgetPro::setMode(KSoundWidget::Mode m)
{
	ksw->setMode(m);
}

void	KSoundWidgetPro::setBusy(bool b)
{
	ksw->setBusy(b);
}

bool	KSoundWidgetPro::isBusy()
{
	return ksw->isBusy();
}

void	KSoundWidgetPro::setSample(CSample *s)
{
	int		t;

	for(t = 0;t < nchannel * 2;t++)
	{
		delete ksb[t];
	}

	ksw->getSample()->equalize(s);

	nchannel = ksw->getSample()->getNChannel();

	ksb.resize(2 * nchannel);
	for(t = 0; t < nchannel;t++)
	{
		ksb[t * 2] = new KScaleBar(this,LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setMode(LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setRange(1,1);
		ksb[t * 2]->setNMarks(5);
		ksb[t * 2]->setFormatString("%1.1f\0");
		ksb[t * 2]->show();

		ksb[t * 2 + 1] = new KScaleBar(this,RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setMode(RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setRange(1,1);
		ksb[t * 2 + 1]->setNMarks(5);
		ksb[t * 2 + 1]->setFormatString("%1.1f\0");
		ksb[t * 2 + 1]->show();
	}

	layout();
}

void	KSoundWidgetPro::setSample()
{
	int		t;

	for(t = 0;t < nchannel * 2;t++)
	{
		delete ksb[t];
	}

	//ksw->setSample(s);

	nchannel = ksw->getSample()->getNChannel();

	ksb.resize(2 * nchannel);
	for(t = 0; t < nchannel;t++)
	{
		ksb[t * 2] = new KScaleBar(this,LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setMode(LEFT_SIDED|ZERO_MID);
		ksb[t * 2]->setRange(1,1);
		ksb[t * 2]->setNMarks(5);
		ksb[t * 2]->setFormatString("%1.1f\0");
		ksb[t * 2]->show();

		ksb[t * 2 + 1] = new KScaleBar(this,RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setMode(RIGHT_SIDED|ZERO_MID);
		ksb[t * 2 + 1]->setRange(1,1);
		ksb[t * 2 + 1]->setNMarks(5);
		ksb[t * 2 + 1]->setFormatString("%1.1f\0");
		ksb[t * 2 + 1]->show();
	}

	layout();
}

void	KSoundWidgetPro::getColors(QColor *color)
{
	ksw->getColors(color);
}

void	KSoundWidgetPro::setColors(QColor *color)
{
	ksw->setColors(color);
}
	
KSoundWidget::Mode		KSoundWidgetPro::getMode()
{
	return ksw->getMode();
}

int			KSoundWidgetPro::loadWave(char* fn)
{	// Saver
	/*int		result;
	CSample		*s = new CSample();

	if((result = s->loadWave(fn)) == 0)
	{
		setSample(s);
	}

	delete s;

	return result;*/
	// Faster
	return ksw->getSample()->loadWave(fn);
}

int		KSoundWidgetPro::saveWave(char* fn)
{
	return ksw->getSample()->saveWave(fn);
}

CSample		*KSoundWidgetPro::getSample()
{
	return ksw->getSample();
}

int		KSoundWidgetPro::setZoom(int zoom,bool repaint)
{
	ksw->setDisplayZoom(zoom,repaint);
	return ksw->getDisplayZoom();
}

int		KSoundWidgetPro::getZoom(void)
{
	return ksw->getDisplayZoom();
}

int		KSoundWidgetPro::setDisplayStart(int ds,bool repaint)
{
	ksw->setDisplayStart(ds,repaint);
	return ksw->getDisplayStart();
}

int		KSoundWidgetPro::getDisplayStart(void)
{
	return ksw->getDisplayStart();
}

int		KSoundWidgetPro::setDisplayEnd(int de,bool repaint)
{
	ksw->setDisplayEnd(de,repaint);
	return ksw->getDisplayEnd();
}

int		KSoundWidgetPro::getDisplayEnd(void)
{
	return ksw->getDisplayEnd();
}

int		KSoundWidgetPro::setDisplayCenter(int dc,bool repaint)
{
	ksw->setDisplayCenter(dc,repaint);
	return ksw->getDisplayCenter();
}

int		KSoundWidgetPro::getDisplayCenter(void)
{
	return ksw->getDisplayCenter();
}

unsigned int	KSoundWidgetPro::getSelectionStart()
{
	return ksw->getSelectionStart();
}

unsigned int	KSoundWidgetPro::getSelectionEnd()
{
	return ksw->getSelectionEnd();
}

void		KSoundWidgetPro::setSelectionStart(int ss,bool repaint)
{
	ksw->setSelectionStart(ss,repaint);
}

void		KSoundWidgetPro::setSelectionEnd(int se,bool repaint)
{
	ksw->setSelectionEnd(se,repaint);
}

int		KSoundWidgetPro::getPointer()
{
	return ksw->getPointer();
}

int		KSoundWidgetPro::setPointer(int pos,bool repaint)
{
	ksw->setPointer(pos,repaint);
	return ksw->getPointer();
}

int		KSoundWidgetPro::screen2sample(int s)
{
	return ksw->screen2sample(s);
}

int		KSoundWidgetPro::sample2screen(int s)
{
	return ksw->sample2screen(s);
}

/**  */
void KSoundWidgetPro::setZoomMax()
{
	long long	l;
	int				z;
	
	l = getSample()->getLength();
	for(z = 0;(l >> z) > 0;z++);
	
	ksw->setDisplayZoom(z);
}


