/* $Id: stereoview.cc,v 1.6 1999/05/05 20:35:41 philipp Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fcntl.h>
#include <unistd.h>
#include <math.h>
#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <qlabel.h>

#include "stereoview.moc"

StereoView::StereoView(QWidget* parent, const char* name, const
			 char* device, unsigned int r, unsigned int i, 
			 unsigned int l)
  : QWidget(parent, name) {
  rate = r;
  intervall = i;
  alloc_buffers();
  openDevice(device);
  setFixedSize(260, 300);
  scope = new StereoScope(this, "scope", l);
  scope->move(2, 2);
  kanzeige = new KorrAnzeige(this, "korrelation");
  kanzeige->setFixedSize(246, 20);
  kanzeige->move(7, 262);

  QLabel* l = new QLabel("0", this);
  l->setAlignment(AlignHCenter | AlignTop);
  l->adjustSize();
  l->move(130 - l->width() / 2, 282);

  l = new QLabel("1", this);
  l->setAlignment(AlignHCenter | AlignTop);
  l->adjustSize();
  l->move(250 - l->width() / 2, 282);

  l = new QLabel("0.5", this);
  l->setAlignment(AlignHCenter | AlignTop);
  l->adjustSize();
  l->move((250 + 130 - l->width()) / 2, 282);

  l = new QLabel("-0.5", this);
  l->setAlignment(AlignHCenter | AlignTop);
  l->adjustSize();
  l->move((10 + 130 - l->width()) / 2, 282);

  l = new QLabel("-1", this);
  l->setAlignment(AlignHCenter | AlignTop);
  l->adjustSize();
  l->move(10 - l->width() / 2, 282);
}

StereoView::~StereoView() {
  killTimer(timer);
  ::close(fd);
  delete [] buffer;
  delete scope;
  delete kanzeige;
}

int StereoView::openDevice(const char* name) {
  int r = 0;
  fd = open(name, O_RDONLY);
  if (fd >= 0) {
    if (!ioctl(fd, SNDCTL_DSP_SPEED, &rate)) {
      int stereoflag = 1;
      if (!ioctl(fd, SNDCTL_DSP_STEREO, &stereoflag)) {
	int format_u8 = AFMT_U8;
	if (!ioctl(fd, SNDCTL_DSP_SETFMT, &format_u8)) {
	  timerEvent(0);
	  timer = startTimer(intervall);
	} else {
	  KMsgBox box(this, i18n("Error"),
		      i18n("Can't set dsp data format"),
		      KMsgBox::STOP, i18n("OK"));
	  box.exec();
	  r = -1;
	}
      } else {
	KMsgBox box(this, i18n("Error"),
		    i18n("Can't set dsp device to stereo"),
		    KMsgBox::STOP, i18n("OK"));
	box.exec();
	r = -1;
      }
    } else {
      KMsgBox box(this, i18n("Error"), i18n("Failed to set sampling rate"),
		  KMsgBox::STOP, i18n("OK"));
      box.exec();
      r = -1;
    }
    devicename = name;
  } else {
    KMsgBox box(this, i18n("Error"), i18n("Can't open dsp device"),
		KMsgBox::STOP, i18n("OK"));
    box.exec();
    r = -1;
  }
  return r;
}

int StereoView::setzeDevice(const char* name) {
  killTimer(timer);
  ::close(fd);
  if (openDevice(name) < 0) return -1;
  timer = startTimer(intervall);
  return 0;
}

void StereoView::setzePunktLog(unsigned int l) {
  scope->setzePunktLog(l);
}

int StereoView::setzeRate(unsigned int r) {
  rate = r;
  if (ioctl(fd, SNDCTL_DSP_SPEED, &rate)) {
    KMsgBox box(this, i18n("Error"),
		i18n("Failed to set sampling rate"),
		KMsgBox::STOP, i18n("OK"));
    box.exec();
    killTimer(timer);
    return -1;
  }
  realloc_buffers();
  return 0;
}

void StereoView::setzeIntervall(unsigned int i) {
  killTimer(timer);
  intervall = i;
  realloc_buffers();
  timer = startTimer(intervall);
}

void StereoView::realloc_buffers() {
  delete [] buffer;
  alloc_buffers();
}

void StereoView::alloc_buffers() {
  maxpunkte = (unsigned int) (rate * (double) intervall * 1.5e-3);
  buffer = new unsigned char [maxpunkte * 2];
}

void StereoView::timerEvent(QTimerEvent* tevt) {
  int status = read(fd, buffer, maxpunkte * 2);
  if (status > 0) {
    scope->neueDaten(buffer, status);
    kanzeige->neueDaten(buffer, status);
  }
}
