	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synth.h"
#ifdef HAVE_MINI_STL
#include <ministl/list>
#else
#include <list>
#endif

#include <kapp.h>
#include <ktopwidget.h>
#include <kfiledialog.h>
#include <ksimpleconfig.h>
#include <qlistbox.h>
#include <qtablevw.h>
#include <qpainter.h>
#include <qdrawutl.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <string.h>
#include "module.h"
#include "autorouter.h"
#include "portpropdlg.h"
#include "execdlg.h"
#include "utils.h"

class ModuleWidget :public QTableView
{
	Q_OBJECT
protected:
	int cellsize,cols,rows,modnr;
	QPoint movestart;
	bool inUpdate;
	Module *newModule;

	AutoRouter *autorouter;

// for connecting ports

	ModulePort *lastport;
	int selectedports;

	list<Module *> *ModuleList;
	list<QRect> UpdateList;

	char *cropText(QPainter *p, char *text, int maxlen, int& textwidth);
	void paintCell(QPainter *p, int y, int x);
	void paintCellBackground(QPainter *p, int y, int x);
	void paintConnection(QPainter *p, int x, int y, int arx, int ary);
	void paintConnections(QPainter *p, int y, int x);
	void mousePressEvent( QMouseEvent *e );
	void mouseMoveEvent( QMouseEvent *e );
	void mouseReleaseEvent( QMouseEvent *e );

	Module *findModule(int x,int y,bool ignore_selected=false);
	bool hasSpace(Module *m,int destx,int desty,bool ignore_selected=false);
	bool connectPorts(ModulePort *src, ModulePort *dest);

	ModulePort *findPort(Module *m, int xoffset, int direction);

	void reRoute();
	void unselectAll();

	void beginUpdate();
	void redrawModule(Module *m);
	void redrawCells(QRect &r);
	void endUpdate();

public:
	void addModule(Module *module);
	void reInit(int nextmodnr);

	ModuleWidget(list<Module *> *ModuleList, QWidget *parent=0,
								const char *name=0, WFlags f=0);

public slots:
	void setZoom(int zoom);
};

class ModuleView :public KTopLevelWidget
{
	Q_OBJECT
private:
    ModuleWidget *modulewidget;
	KMenuBar *menubar;
	KSynthesizer *Synthesizer;
	list<Module *> ModuleList;

public:
	ModuleView(const char *name, KSynthesizer *Synthesizer);
	void clear();

public slots:
	void addModule(int module);
	void save();
	void open();
	void execute();
};
