	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synthmodule.h"
#include <sys/types.h>
#include <sys/time.h>
#include <termios.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include "midibus.h"

extern "C" {
#include "utils.h"
#include "sound.h"
}

class Synth_MIDI_SOURCE;

class MidiChannel_impl :virtual public MidiChannel_skel
{
	Synth_MIDI_SOURCE *cl;
	float frequency[256]; // convert a midi-note to a frequency
public:
	MidiChannel_impl()
	{
    	float freq[]  = { 261.7,277.2,293.7,311.2,329.7,349.3,370.0,392.0,
						  415.3,440.0, 466.2,493.9, 0 };
    	float zhoch[24];
		int i;

		for(i=0;i<24;i++) zhoch[i] = (1 << i);
		for(i=0;i<256;i++)
		{
			frequency[i] = freq[i%12];
			frequency[i] *= zhoch[i/12] / zhoch[4];
		}
	}
    void noteOn( CORBA::Octet channel, CORBA::Octet note, CORBA::Octet volume );
    void noteOff( CORBA::Octet channel, CORBA::Octet note );
	void Register(Synth_MIDI_SOURCE *client) { cl = client; };
};

class Synth_MIDI_SOURCE :public SynthModule
{
	#define CHANNEL 0
	#define ACTIVE 0
	#define FREQUENCY 1 
	#define VOLUME 2
	#define SAMPLINGRATE 44100

	static MidiChannel_impl *midich;
	float active,volume,frequency;

public:
	int channel;

	void SetParams(int active,int volume,float frequency)
	{
		if(active > 0) {
			this->active = 1;
		} else this->active = 0;
		this->active = active;
		this->volume = volume/256;
		this->frequency = frequency;
	}
	void Initialize(string info)
	{
		if(!midich) midich = new MidiChannel_impl;
		midich->Register(this);
	}
	void Calculate();
	string getParams() { return("channel;active,frequency,volume"); };
	static void *Creator() { return new Synth_MIDI_SOURCE; }
};

static MidiChannel_impl *Synth_MIDI_SOURCE::midich = 0;

ModuleClient MC_Synth_MIDI_SOURCE(SynthModule::get_MS,"Synth_MIDI_SOURCE",Synth_MIDI_SOURCE::Creator);

void Synth_MIDI_SOURCE::Calculate()
{
	channel = *in[CHANNEL];
	*out[ACTIVE] = active;
	*out[FREQUENCY] = frequency;
	*out[VOLUME] = volume;
};

void MidiChannel_impl::noteOn( CORBA::Octet channel, CORBA::Octet note, CORBA::Octet volume )
{
	cl->SetParams(1,volume,frequency[note]);
};

void MidiChannel_impl::noteOff( CORBA::Octet channel, CORBA::Octet note )
{
	cl->SetParams(0,0,frequency[note]);
};

