/***************************************************************************
                          aclock.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// aclock.cpp
// ktuner v0.1 , Carl van Schaik
// e-mail carl@leg.uct.ac.za

#include "aclock.h"
#include <qtimer.h>
#include <qpainter.h>

analogClock::analogClock( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    initMetaObject();				// initialize meta object
    time = QTime::currentTime();
}

void analogClock::paintEvent( QPaintEvent * )	// paint clock
{
    if ( !isVisible() )				// is is invisible
	return;

    QPointArray pts;
    QPainter paint;
    paint.begin( this );
    paint.setPen( red  );

    if (time.hour() > 11)
      paint.drawText(0,0,17,17,AlignCenter,"PM");
    else
      paint.drawText(0,0,17,17,AlignCenter,"AM");

    paint.setBrush( blue );
    paint.setPen( black  );

    QPoint cp = rect().center();		// widget center point
    int d = QMIN(width(),height());		// we want a circular clock

    QWMatrix matrix;				// setup transformation matrix
    matrix.translate( cp.x(), cp.y() );		// origin at widget center
    matrix.scale( d/1000.0F, d/1000.0F );	// scale coordinate system

    float h_angle = 30*(time.hour()%12-3) + time.minute()/2;
    matrix.rotate( h_angle );			// rotate to draw hour hand
    paint.setWorldMatrix( matrix );
    //pts.setPoints( 4, -20,0,  0,-20, 300,0, 0,20 );
    pts.setPoints( 6, -100,0,  0,-20, 250,-10, 280,0, 250,10, 0,20 );
    paint.drawPolygon( pts );			// draw hour hand
    matrix.rotate( -h_angle );			// rotate back to zero

    float m_angle = (time.minute()-15)*6;
    matrix.rotate( m_angle );			// rotate to draw minute hand
    paint.setWorldMatrix( matrix );
    pts.setPoints( 4, -150,0, 0,-20, 400,0, 0,20 );
    paint.drawPolygon( pts );			// draw minute hand
    matrix.rotate( -m_angle );			// rotate back to zero

    paint.setBrush( green );
    for ( int i=0; i<12; i++ ) {		// draw hour lines
      paint.setWorldMatrix( matrix );
      paint.drawEllipse (450,0,40,40);
      matrix.rotate( 30 );
    }

    paint.end();
}

void analogClock::setTime(int Hr, int Min)
{
  time.setHMS(Hr,Min,0);;
  repaint();
}
