/***************************************************************************
                          hardware.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// hardware.h
// CRadio/ktuner (Carl Radio) v 0.9 : Carl van Schaik 1998
// e-mail carl@leg.uct.ac.za
//
// Some hardware code derived from
// xradiotrack V.1.1  F.W.Brinkman 1995.
//
// Radiotrack II implementation : Leendert Meyer (leendert@usa.net).
//
// RadioTrack II Protocol : Ben Pfaff


#ifndef HARDWARE_H
#define HARDWARE_H

#include "conf.h"

// Base class for radio card
// This is to make it easy to implement other cards
class radioCard
{
 public:
  radioCard() {};

  virtual int init(int,int) = 0; //Initialises the card (and returns 1 if error)

  virtual void cardOff() = 0;
  virtual void cardOn() = 0;
  virtual int cardToggle() = 0;  //Same as mute (if off, sets it on etc)

  virtual void volDown() = 0;
  virtual void volUp() = 0;
  virtual void setVolume(int) = 0;
  virtual int getVolume() = 0;

  virtual void tuneFreq(double) = 0;
  virtual int isTuned() = 0;

  //double getFreq();  // Not implemented yet ?? Anyone have any ideas?

 protected:
  virtual void cardWrite(int) = 0;
  int getIoPrivs();
  void giveUpRoot();

  int cardFound;
  int volume;
  int cardBase;
  int onOff;
  int muted;

  configFile* conf;
};

// Other cards should also be implemented
class rtrack : public radioCard
{
 public:
  rtrack(configFile*);
  virtual ~rtrack() {};

  int init(int,int); //Initialises the card (and returns 1 if error)

  void cardOff();
  void cardOn();
  int cardToggle();  //Same as mute (if off, sets it on etc)

  void volDown();
  void volUp();
  void setVolume(int);
  int getVolume();

  void tuneFreq(double);
  int isTuned();

  //double getFreq();  // Not implemented yet ?? Anyone have any ideas?

 protected:
  void cardWrite(int);
};

// RadioTrack Version II
class rtrackII : public radioCard
{
 public:
  rtrackII(configFile*);
  virtual ~rtrackII() {};

  int init(int,int); //Initialises the card (and returns 1 if error)

  void cardOff();
  void cardOn();
  int cardToggle();  //Same as mute (if off, sets it on etc)

  void volDown();
  void volUp();
  void setVolume(int);
  int getVolume();

  void tuneFreq(double);
  int isTuned();

  //double getFreq();  // Not implemented yet ?? Anyone have any ideas?

 protected:
        void cardWrite(int);
        void zero(void);
        void one(void);
};

class zoltrix : public radioCard
{
 public:
  zoltrix(configFile*);
  virtual ~zoltrix() {};

  int init(int,int); //Initialises the card (and returns 1 if error)

  void cardOff();
  void cardOn();
  int cardToggle();  //Same as mute (if off, sets it on etc)

  void volDown();
  void volUp();
  void setVolume(int);
  int getVolume();

  void tuneFreq(double);
  int isTuned();

  //double getFreq();  // Not implemented yet ?? Anyone have any ideas?

 protected:
  void cardWrite(int);
  int cardRead(int offset); // reads from (cardBase + offset)
};

#ifdef USE_KERNEL

class kernelCard : public radioCard
{
 public:
  kernelCard(configFile*);
  ~kernelCard();

  int init(int,int); //Initialises the card (and returns 1 if error)

  void cardOff();
  void cardOn();
  int cardToggle();  //Same as mute (if off, sets it on etc)

  void volDown();
  void volUp();
  void setVolume(int);
  int getVolume();

  void tuneFreq(double);
  int isTuned();

  //double getFreq();  // Not implemented yet ?? Anyone have any ideas?

 protected:
  double lastF;
  unsigned long lastFr;
  int save, dev;

  void cardWrite(int);
};
#endif //USE_KERNEL

#endif
