// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/InputModuleFile.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#ifndef InputModuleFile_h
#define InputModuleFile_h

#include <fstream.h>
#include <string>
#include <regex.h> // Yeah, I like them!

#include "LookInfo.h"

class EditorInfo;

class InputModuleFile
{
    static const long lowest_compatibility = 2;
    static const long highest_compatibility = 2;
    
    string filename;
    bool good;

    /**
     * Number of last read input line.
     */
    long line_number;

    /**
     * Line where most recent error occured.
     */
    long error_line_number;

    /**
     * Describes the error in case of failed open.
     */
    string errortext;
    ifstream input;
    string version_string;
    int major_version,
	minor_version,
	sub_minor_version,
	compatibility_level;

    // Regex stuff for parsing
    regex_t regex_modules;    // Beginning of Modules-section
    regex_t regex_module;     // entry of one module
    regex_t regex_wires;      // Beginning of WIRES-section
    regex_t regex_wire;       // entry of one wire
    regex_t regex_byteblock;  // Line with "Length: <length>"
    regex_t regex_look_info;
    regex_t regex_editor_info;

public:
    InputModuleFile(const char *filename);
    ~InputModuleFile();
    
    bool   isGood() const { return good && input.good(); };
    int    majorVersion() const { return major_version; };
    int    minorVersion() const { return minor_version; };
    int    subMinorVersion() const { return sub_minor_version; };
    int    compatibilityLevel() const { return compatibility_level; };
    bool   isCompatible() const { return compatibilityLevel() >= lowest_compatibility
				    &&   compatibilityLevel() <= highest_compatibility; };
    string getFilename() const;

    /**
     * Description of the error, when @ref isGood results in false.
     */
    string errorText() const { return errortext; };

    void setError(string /*text*/);

    long errorLineNumber() const { return error_line_number; };

    string readLine();
    long   readLong();
    double readDouble();
    long   beginReadingSection(regex_t *regex, const char *headername);
    long   beginReadingSubmodules() { return beginReadingSection(&regex_modules, "Submodules"); };
    long   beginReadingWires()   { return beginReadingSection(&regex_wires, "Wires"); };

    void   readModule(long index, string& name, string& constructor,
		      short& xpos, short& ypos, bool& visible, long& numparslots, string *parslots);
    void   readWire(long& from, string& signal, long& to, string& slot);
    long   readByteBlock(unsigned char * &block);
    void   skipByteBlock();
    void   readPixmap(LIPixmap& pixmap);
    void   readLookInfo(LookInfo& look_info);
    void   readEditorInfo(EditorInfo& editor_info);
    void   skipHeader();
private:
    long   readByteBlockHeader();
};


#endif // InputModuleFile_h
