// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/LookInfo.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#ifndef LookInfo_h
#define LookInfo_h

#include <string>

struct LIColor
{
    short r, g, b;
    LIColor(short r=0, short g=0, short b=0) : r(r), g(g), b(b) {};
};


struct LIPixmap
{
    unsigned char *imagedata;
    long imagesize;

    LIPixmap() : imagedata(0), imagesize(0) {};

    LIPixmap(unsigned char *imagedata, long imagesize) : 
	imagedata(imagedata), imagesize(imagesize) {};

    ~LIPixmap() { if (imagesize) delete imagedata; };

    LIPixmap &operator = (const LIPixmap &px) {
	if (imagesize) delete imagedata;
	imagesize = px.imagesize;
	if (imagesize) 
	{
	    imagedata = new unsigned char[px.imagesize];
	    memcpy(imagedata, px.imagedata, px.imagesize);
	}
	return *this;
    }

    void setImage(unsigned char *data, long size) {
	if (imagesize) delete imagedata;
	imagedata = data;
	imagesize = size;
    }
};


struct LIRect
{
    short left, top, width, height;
    LIRect(short left=0, short top=0, short width=0, short height=0) 
	: left(left), top(top), width(width), height(height) {};
};


/**
 * @short Parameters for Look of a MacroModule.
 */
struct LookInfo
{
    string       name;
    string       description;
    bool         text_layout;
    bool         image_layout;
    bool         separators;
    bool         threed_border;
    bool         rounded_edges;
    LIColor      backgroundcolor;
    LIColor      textcolor;
    LIRect       layout_rect;    
    string       layout_text;
    LIPixmap     image;
    LIPixmap     preview;
    LookInfo(); // set default values;
};

#endif // LookInfo_h
