// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/OutputModuleFile.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#ifndef OutputModuleFile_h
#define OutputModuleFile_h

#include <fstream.h>
#include <string>

#include "LookInfo.h"
#include "EditorInfo.h"

class Module;
class Wire;

class OutputModuleFile
{
    static const long compatibility_level = 2; // add 1 each time, format is changed incompatibly
    ofstream output;
public:
    OutputModuleFile(const char *filename);
    bool isGood() const { return output.good(); };
    void writeDouble(double);
    void writeLine(string);
    void writeLong(long);
    void beginWritingModules(long number);
    void writeModule(const Module *module);
    void beginWritingWires(long number);
    void writeWire(const Wire *);
    void writeByteBlock(const char *comment, const unsigned char *block, long length);
    bool writeByteBlock(const char *comment, const char *filename);
    void writePixmap(const char *comment, const LIPixmap& pixmap);
    void writeLookInfo(const LookInfo& lookinfo);
    void writeEditorInfo(const EditorInfo& editorinfo);
};

#endif // OutputModuleFile_h
