// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Parameterset.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#ifndef Parameterset_h
#define Parameterset_h

#include "BasicTypes.h"

class Parameterset
{
    enum type { SAMPINT=0x01, DURATION_FACTOR=0x02, CHANNEL=0x04 };

    Seconds         sampint;
    Number          duration_factor;
    unsigned short  channel;
    unsigned short  containsbits;  

public:
  Parameterset() : containsbits(0) {};

  bool containsSamplingInterval() const { return 0 != (containsbits & SAMPINT); };
  bool containsDurationFactor()   const { return 0 != (containsbits & DURATION_FACTOR); };
  bool containsChannel()          const { return 0 != (containsbits & CHANNEL); };

  void setSamplingInterval(Seconds s=0) { sampint = s;         containsbits |= SAMPINT;};
  void setDurationFactor(Number d=0)    { duration_factor = d; containsbits |= DURATION_FACTOR; };
  void setChannel(unsigned short c=0)   { channel = c;         containsbits |= CHANNEL; };

  Seconds        getSamplingInterval() const { return sampint; };
  Number         getDurationFactor()   const { return duration_factor; };
  unsigned short getChannel()          const { return channel; };

  void clearSamplingInterval()               { containsbits &= ~SAMPINT; };
  void clearDurationFactor()                 { containsbits &= ~DURATION_FACTOR; };
  void clearChannel()                        { containsbits &= ~CHANNEL; };
  void clear()                               { containsbits = 0; };

  int comparedTo(const Parameterset& p) const;
};


inline int Parameterset::comparedTo(const Parameterset& p) const
{
  if (containsbits != p.containsbits) return containsbits - p.containsbits;
  if (containsChannel() && channel != p.channel) return channel - p.channel;
  if (containsSamplingInterval() && sampint != p.sampint)
    return sampint > p.sampint ? 1 : -1;
  if (containsDurationFactor() && duration_factor != p.duration_factor) 
    return duration_factor > p.duration_factor ? 1 : -1;
  return 0;
}


#endif // Parameterset_h
