// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Signal.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#ifndef Signal_h
#define Signal_h

#include "Connector.h"

class Module;
class Slot;
class Metainfo;
class Parameterset;
class PreparedSignal;

class Signal : public Connector
{
protected:
    /**
     * Stores the Slot that asked to get the value (@ref Number, @ref PreparedSoundSignal )
     * of this Signal. Will be used for asking for parameter Signals in return.
     */
    Slot *asking_slot;

public:
    /**
     * Initializes the Signal base class.
     * @param module Module this Signal belongs to
     */
    Signal(SignalType type, string name, string description, Module *module);

    bool isSignal() const { return true; };

    /**
     * A Slot of the same Module asks this Signal to try to get a parameter signal.
     * 
     * this Slot is in the call <some_signal> -> getSignal(this) and means "To answer
     * your demand of calculating the Signal I first need some parameter
     * Signal from you!". The default
     * @param name Name of the parameter signal. 
     */
    Signal *getParameterSignal(const char *name);

    /**
     * This function must be overridden to actually implement the meaning of a Signal.
     * This is done by classes in the files modules/M*.cc
     * 
     */
    virtual PreparedSignal *prepareSignal(Metainfo *mi=0, const Parameterset *ps=0) = 0;
    
    /**
     * Small wrapper around @ref #prepareSignal, that sets and clears the variable
     * @ref #asking_slot.
     */
    PreparedSignal *getPreparedSignal(Slot *asking_slot, Metainfo *mi=0, const Parameterset *ps=0);
};

#endif // Signal_h
