// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Wire.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/15 22:48:23 $
// $State: Exp $
// **************************************************************

#include "Wire.h"
#include "Connector.h"
#include "Module.h"

Wire::Wire(Connector *signal, Connector *slot, Module *signal_module, Module *slot_module)
    : signal(signal)
    , slot(slot)
    , signal_module(signal_module)
    , slot_module(slot_module)
{
}


bool Wire::bothModulesAreSelected() const
{
    return signal_module->isSelected() 
	&& slot_module->isSelected();
}

bool Wire::isConnectedTo(const Module *module) const
{
    return module == signal->getModule()
	|| module == slot->getModule()
	|| module == signal_module
	|| module == slot_module;
}
