// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESCarryingForInsertion.h,v $
// $Revision: 1.2 $
// $Date: 1999/05/16 19:14:53 $
// $State: Exp $
// **************************************************************

#ifndef ESCarryingForInsertion_h
#define ESCarryingForInsertion_h

#include <qpoint.h>

#include "EditorState.h"

class ModuleLookGenerator;
class ModuleLook;

class ESCarryingForInsertion : public EditorState
{
    ModuleLookGenerator *module_look_generator;

    /** 
     * Needed in the special case, a ET_FILEREF MacroModule is beeing
     * inserted. There is not a generator for each possible file to be
     * inserted. The variable stores a pointer to the generated ModuleLook.
     */
    ModuleLook          *module_look;

    QPoint grid_position;
    QSize  size;

public:
    ESCarryingForInsertion(MacroModuleLook *mml, ModuleLookGenerator *module_look_generator);
    ESCarryingForInsertion(MacroModuleLook *mml, ModuleLook *module_look);
    ~ESCarryingForInsertion();
    void enter();
    void leave();

protected:
    void paintEvent(QPainter&, const QRect&);
    EditorState *leftButtonPressed   (const QMouseEvent *);
    EditorState *mouseMoved          (const QMouseEvent *);

private:
    void needsUpdate();
};


#endif // ESCarryingForInsertion_h
