// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESOperatingControl.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/16 19:14:53 $
// $State: Exp $
// **************************************************************

#include "ESOperatingControl.h"
#include "ESNothing.h"
#include "ModuleLook.h"

ESOperatingControl::ESOperatingControl(MacroModuleLook *mml, QPoint position, ModuleLook *module_look)
    : EditorState(mml)
    , module_look(module_look) 
    , start_position(position)
{
}
    

void ESOperatingControl::enter()
{
    mml->setMouseTracking(TRUE); // I need this as you will see later
    if (module_look->mousePressed(start_position)) mml->needsUpdate(module_look);
}

void ESOperatingControl::leave()
{
    mml->setMouseTracking(FALSE);
    if (module_look->mouseReleased()) mml->needsUpdate(module_look);
}

EditorState *ESOperatingControl::rightButtonReleased(const QMouseEvent *)
{
    return new ESNothing(mml);
}

EditorState *ESOperatingControl::mouseMoved(const QMouseEvent *event)
{
    // I'll tackle the following problem: If the user right-clicks on
    // some types of control modules like number or text, a small modal
    // dialog opens allowing him to enter a number or a text. This dialog
    // will steal the "Right-Button-Up" event thus leaving the user
    // for ever in ESOperatingControl.

    // I repair it fairly simple: A mouse move without pressed right button
    // will return to ESNothing.

    if ((event->state() & RightButton) == 0) return new ESNothing(mml);

    if (module_look->mouseMoved(event->pos() - module_look->pos())) mml->needsUpdate(module_look);
    return this;
}
