// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/MacroModuleLook.h,v $
// $Revision: 1.4 $
// $Date: 1999/05/16 19:14:53 $
// $State: Exp $
// **************************************************************

#ifndef MacroModuleLook_h
#define MacroModuleLook_h

#include <sys/timeb.h>
#include <iostream.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qlist.h>
#include <qpoint.h>
#include <qevent.h>
#include <qfiledlg.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>

#include "SamplingConfigDialog.h"
#include "MacroModule.h"
#include "ModuleLook.h"
#include "WireLook.h"
#include "Annotation.h"
#include "LookInfo.h"

class MusicdrawTopLevel;
class InputModuleFile;
class OutputModuleFile;
class Wirebox;
class EditorState;

enum DragPosition { NONE=0x00, LEFT=0x01, RIGHT=0x02, TOP=0x04, BOTTOM=0x08 };
#define LAYOUT_RECT_THICKNESS 5

/**
  * @short User interface for editing the internal structure of a MacroModule.
  */
class MacroModuleLook : public ModuleLook
{
    friend class MacroModuleEditor;

    /**
     * Toplevel widget handles File saving/loading for user.
     */
    MusicdrawTopLevel *toplevel;

    /**
     * Widget that is editing me. May be 0.
     */
    MacroModuleEditor *mme;

    /**
     * Underlying MacroModule, which is being edited;
     */
    MacroModule *macromodule;

    // GUI stuff
    QPopupMenu edit_menu, layout_menu, modules_menu, execute_menu;
    QPopupMenu *wire_menu;
    int menuid_undo, menuid_redo, menuid_copy, menuid_paste, menuid_cut, menuid_select_all,
	menuid_save_sel, menuid_rewire, menuid_flip_horiz, menuid_flip_vert, menuid_show_rect, 
	menuid_add_to_layout, menuid_remove_from_layout, menuid_look_dialog, menuid_play, 
	menuid_pause, menuid_stop, menuid_samplingconfig;
    KToolBar *toolbar;
    enum { toolbarid_copy = 100, toolbarid_cut, toolbarid_paste, toolbarid_undo, toolbarid_redo,
	   toolbarid_rewire, toolbarid_play, toolbarid_pause, toolbarid_stop };
    KStatusBar *statusbar;
    int statusbarid_time, statusbarid_pause, statusbarid_modulename, statusbarid_modified;
    QFileDialog *macro_module_file_dialog;

    // Stuff I consist of
    QList<ModuleLook>     module_looks;     // GUIs of the submodules
    QList<WireLook>       wire_looks;       // Layout info of the wires
    QList<Annotation>     annotations;      // is drawn, but not moved.
    Wirebox              *wirebox;          // needed to nicely layout wires.
    
    // Editor states
    EditorState *editor_state; // Handles all events!
    friend class EditorState;
    friend class ESNothing;
    friend class ESDraggingModules;
    friend class ESDraggingLayoutRect;
    friend class ESDraggingRectangle;
    friend class ESCarryingForInsertion;
    friend class ESWireing;
    friend class ESOperatingControl;

    bool modified;
    int  undo_level;           // During undo/redo number of just loaded undo file.
    int  highest_undo_file;    // highest number of existing undo files. Starting with 0.
    bool edit_layout;          // Just editing look?

    QRect rectangle_to_update; // minimal enclosing rect of all areas the must be repainted

    // Playing
    struct timeb time_started_playing;
    long sampling_time;
    int frags_to_next_display_refresh;
    static const Seconds sampling_interval = Seconds(1) / 44100.0; // TODO: Make parameter
    QList<Module> modules_to_play;
    bool paused;
    bool playing;
    SamplingConfigExt sampling_config;
    
    ModuleLook *produced_wire_menu;

    // Acting as a ModuleLook (and thus LayoutElement) myself

    ModuleLook *mouse_pressed_over;

    /**
     * If the look if this Module contains a pixmap, the imagedata is stored
     * in a bytebuffer in macromodule->look_info. Because I don't want to
     * convert this to a Qt Pixmap every repaint, I always store a corresponding
     * pixmap in this variable. Everytime the look_info changes, the variable
     * must be constructed anew.
     */ 
    QPixmap     layout_image;

public:
    /**
     * Creates a new MacroModuleLook. 
     * @param toplevel MusicdrawTopLevel Parent widget.
     * @param macromodule MacroModule that will be edited;
     */
    MacroModuleLook(MusicdrawTopLevel *toplevel, MacroModule *macromodule, bool editor=true);

    ~MacroModuleLook();

    void initialize(MacroModuleEditor *mme);
    void readSamplingConfig();
    void writeSamplingConfig();

    // Access for MusicdrawToplevel

    bool insertFile(InputModuleFile& imf, const QPoint& offset=QPoint(0,0));
    bool saveToFile(OutputModuleFile&, bool now_not_mod=false, bool sel_only=false);
    void preparePreview();
    bool preparedToDie();
    void addMenus(KMenuBar *);
    void addToolbarButtons(KToolBar *);
    void addStatusbarItems(KStatusBar *);
    void removeToolbarButtons();
    void keyPressed(QKeyEvent *e);

private:

    // plugins

    void scanPlugins() const;

    // creating and maintaining menues

    void initializeEditMenu();
    void initializeMacroModuleMenu();
    void initializeModulesMenu();
    void initializeExecuteMenu();
    
    // loading
    
    bool reloadFromFile(InputModuleFile&);
    bool loadFromFile(InputModuleFile&, bool, string& parameterlist, const QPoint& offset=QPoint(0,0));
    void syncNewModules();
    
    // painting

    /**
     * Inherited from @ref ModuleLook. Determines if this modules data has changed
     * and thus the module's graphical representation should be refreshed.
     */
    bool needsRepaint();

    void  paintEvent(QPaintEvent *);
    void  paintCanvas(QPainter&, const QRect&) const;
    void  paintAuras(QPainter&, const QRect&);
    void  paintGrid(QPainter&, const QRect&) const;
    void  paintLayoutRect(QPainter&, const QRect&) const;
    short roundUpToGrid(short) const;
    void  paintModuleLooks(QPainter&, const QRect&);
    void  paintAnnotations(QPainter&, const QRect&);
    void  needsUpdate(const QRect&);
    void  needsUpdate(const ModuleLook *);
    void  needsUpdate(const Annotation *);
    void  needsUpdateLayoutRect();
    void  doUpdate();
    
    // receiving events
    
    void mousePressEvent(QMouseEvent *e)   { handleEvent(e); };
    void mouseReleaseEvent(QMouseEvent *e) { handleEvent(e); };
    void mouseMoveEvent(QMouseEvent *e)    { handleEvent(e); };
    void handleEvent(QEvent *);
    void setMouseTracking(bool);
    
    // carry out user commands
    
    void goToEditorState(EditorState *);
    void popupWireMenu(ModuleLook *ml, Connector *c=0);
    void cancelCurrentUserAction();
    void selectModule(ModuleLook *);
    void deselectModule(ModuleLook *);
    void toggleSelection(ModuleLook *);
    void deselectAllModules();
    void rectangularSelection(const QRect& old_rect, const QRect& new_rect);
    void deleteModuleLooks(bool selection_only=false);
    void flipSelection(bool horizontally);
    
    // carry out user actions

    bool dragSelectedModules(const QPoint&); // true: was able to move
    void moveModuleLook(ModuleLook *le, const QPoint&);
    
    // annotations
    
    void addAnnotation(Annotation *);
    void annotationBack(Annotation *);
    void removeAnnotation(Annotation *);
    void removeAllAnnotations();
    void showErrorAnnotation(ModuleLook *, ModuleErrorReport *);
    Annotation *findAnnotationAt(const QPoint&);
    bool checkForModuleErrors();
    
    // handle status bar

    void showPlayingStatus();
    void showPlayingTime();
    void showModuleName(const char *);
    void showModified();

    // helper functions

    string undoFilename(int level) const;
    void saveForUndo(); // TODO: Desciption of the action: "Undo cut" "Undo move modules"...
    void cleanupUndoFiles(int from_level);
    string clipboardFilename() const;
    bool clipboardFileExists() const;
    void createAndInsertModule(ModuleLookGenerator *, const QPoint&);

    int    numberOfModules();
    int    numberOfSelectedModules();
    int    numberOfWires() const { return wire_looks.count(); };
    int    numberOfIntraSelectionWires();

    QPoint nearestGridPosition(const QPoint &, int align=1) const; // yields grid coordinates!
    QSize  canvasGridSize() const;
    QRect  canvasGridRect() const;
    QSize  canvasSize() const;
    QRect  canvasRect() const;
    QRect  layoutRect() const;
    bool   doesEditLook() const;
    void   setLayoutRect(const QRect&);
    void   refreshLayoutImage();

    /**
     * Creates a ModuleLook out of an existing Module that is already part
     * of the underlying MacroModule. Then adds this ModuleLook using
     * addModuleLook(ModuleLook *).
     */
    void   addModuleLook(Module *);

    /**
     * Adds a ModuleLook. The Module look must contain an existing Module
     * that is already part of the underlying MacroModule.
     */
    void   addModuleLook(ModuleLook *);

    void   addWireLook(ModuleLook*, ModuleLook*, Wire *);

    /**
     * Creates a WireLook out of an existing Wire that is already part
     * of the underlying MacroModule. Adds the WireLook. This method
     * is used to synchronize the wireing structure of the underlying
     * MacroModule with the visible representations of the wires for the user.
     */
    void addWireLook(Wire *);

    ModuleLook *findModuleLookAt(const QPoint&);
    ModuleLook *findModuleLook(const Module *module);
    void   relayoutWiresConnecting(ModuleLook *);
    void   deleteAllWiresConnectedTo(const ModuleLook *ml, const Connector *c=0);
    int    numberOfModuleLooks() const { return module_looks.count(); };
    bool   somethingSelected();
    void   setModified() { modified = true; };
    void   clearModified() { modified = false; };
    void   changeVisibility(bool visible);

    // Represent slots from MacroModuleEditor
    
    void modulesMenuEvent(int module_id);
    void insertMacroModule();
    void startWireingEvent(int connector_id);
    void finishWireingEvent(int connector_id);
    void undo();
    void redo();
    void copy();
    void cut();
    void paste();
    void selectAllModules();
    void rewire();
    void flipHorizontally();
    void flipVertically();
    void editLook();
    void lookDialog();
    void addToLayout();
    void removeFromLayout();
    void play();
    void playNextBlock(); // target for timer event.
    void pause();
    void stop();
    void samplingConfiguration();
    void doGeneralUpdate(int); // index needed because of signal type activated(int)
    void doGeneralUpdate() { doGeneralUpdate(0); };
    void saveSelectionToFile();

    // Acting as a ModuleLook (and thus LayoutElement) myself

public:

    // Inheritance from LayoutElement

    QSize  gridSize()   const;
    QRect  sizeWithBorder() const;
    void   paint(QPainter& p);
    void   paintBorder(QPainter& p) const;
    void   paintSelection(QPainter& p) const;

    // Inheritance from ModuleLook

    bool   isControl();
    bool   mousePressed(const QPoint&);
    bool   mouseMoved(const QPoint&);
    bool   mouseReleased();

    bool   moduleLookIsVisible(ModuleLook *ml) const;
    QPoint positionInLayout(ModuleLook *ml) const;
    void   paint(QPainter& p, const LookInfo *li);
    void   paintBorder(QPainter& p, const LookInfo *li) const;
    QPixmap preview(const LookInfo  *li, const QSize& size);

    QWidget *widget();
};


#endif // MacroModuleLook_h
