 // -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/MusicdrawTopLevel.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#include <qkeycode.h>
#include <qmsgbox.h>
#include <qfiledlg.h>

#include "MusicdrawTopLevel.h"
#include "MusicdrawTopLevel-moc.h"
#include "language.h"
#include "version.h"
#include "InputModuleFile.h"
#include "OutputModuleFile.h"
#include "MacroModule.h"
#include "MacroModuleLook.h"
#include "MacroModuleEditor.h"
#include "Dirs.h"

#include "new.xpm"
#include "open.xpm"
#include "save.xpm"

MusicdrawTopLevel::MusicdrawTopLevel(KApplication *app, const char *)
    : KTopLevelWidget(VERSION_STRING),
      application(app),
      splashscreen(new SplashScreen(this)),
      main_client_widget(0),
      menubar(new KMenuBar(this)),
      toolbar(new KToolBar(this)),
      filedialog(new QFileDialog(0, "*.md", 0, "file_dialog", TRUE))
{
    MacroModule::scanPlugins(global_plugins_dir);
    application->setGlobalMouseTracking(TRUE); // will receive mouse movement even without buttons
    createToolbar();
    addToolBar(toolbar);
    createMenu();
    setMenu(menubar);
    checkMenuAndToolbarEnabling();
    connect(splashscreen, SIGNAL(about()), this, SLOT(about()));
    connect(splashscreen, SIGNAL(help()), this, SLOT(help()));
    connect(splashscreen, SIGNAL(examples()), this, SLOT(examples()));
    splashscreen->show();
    resize(splashscreen->size()  + QSize(0, 51));
    setView(splashscreen);
}


MusicdrawTopLevel::~MusicdrawTopLevel()
{
//    if (main_client_widget) delete main_client_widget;
//    delete file_menu;
//    delete help_menu;
}


void MusicdrawTopLevel::openFile(const char *fn)
{
    if (removeCurrentMainWidget())
    {
	InputModuleFile modulefile(fn);
	if (!modulefile.isGood()) {
		cerr << "Can't open " << fn << " for input." << endl;
	}
	else {
	    macro_module = new MacroModule(MacroModule::ET_TOPLEVEL, "", &modulefile);
	    macro_module_look = 
		new MacroModuleLook(this, macro_module);
	    setNewMainWidget(new MacroModuleEditor(this, macro_module_look));
	    setFilename(fn);
	}
    }
}


OutputModuleFile *MusicdrawTopLevel::getOutputFile(const char *fn)
{
    QString filename;
    if (!fn) {
	filename = askFilename(l_SELECT_FILE_TO_SAVE);
	if (filename.isNull()) return 0;
    }
    else filename = fn;

    OutputModuleFile *modulefile = new OutputModuleFile(filename);
    
    if (modulefile->isGood()) return modulefile;
    else {
	delete modulefile;
	return 0;
    }
}


InputModuleFile *MusicdrawTopLevel::getInputFile(const char *fn)
{
    InputModuleFile *modulefile = new InputModuleFile(fn);
    if (modulefile->isGood()) return modulefile;
    else {
	delete modulefile;
	return 0;
    }
}


void MusicdrawTopLevel::createMenu()
{
    menubar->clear();
    file_menu = new QPopupMenu();
    file_menu                ->insertItem(QPixmap((const char **)new_xpm), 
					  l_NEW, this, SLOT(neww()), CTRL + Key_N);
    file_menu                ->insertItem(QPixmap((const char **)open_xpm), 
					  l_OPEN, this, SLOT(open()), CTRL + Key_O);
    menuid_insert  = file_menu->insertItem(l_INSERT,  this, SLOT(insert()));
    menuid_save    = file_menu->insertItem(QPixmap((const char **)save_xpm), 
					   l_SAVE, this, SLOT(save()), CTRL + Key_S);
    menuid_save_as = file_menu->insertItem(l_SAVE_AS, this, SLOT(saveAs()));
    menuid_close   = file_menu->insertItem(l_CLOSE,   this, SLOT(close()));
    file_menu                ->insertItem(l_QUIT,    this, SLOT(quit()), CTRL+Key_Q);
    menubar->insertItem( l_FILE, file_menu );

    if (main_client_widget) main_client_widget->addMenus(menubar);

    menubar->insertSeparator();

    help_menu = new QPopupMenu();
    help_menu->insertItem("&Online Manual", this, SLOT(help()), Key_F1);
    help_menu->insertItem("&About", this, SLOT(about()));
    menubar->insertItem("&Help", help_menu);

    checkMenuAndToolbarEnabling();
}


// Is only called once: During program initialization. Other that createMenu().
void MusicdrawTopLevel::createToolbar()
{
    toolbar->insertButton(QPixmap((const char **)new_xpm), toolbarid_new,
			 SIGNAL(clicked()), this, SLOT(neww()), TRUE, l_TTT_NEW);
    toolbar->insertButton(QPixmap((const char **)open_xpm), toolbarid_open,
			 SIGNAL(clicked()), this, SLOT(open()), TRUE, l_TTT_OPEN);
    toolbar->insertButton(QPixmap((const char **)save_xpm), toolbarid_save,
			 SIGNAL(clicked()), this, SLOT(save()), TRUE, l_TTT_SAVE);
    toolbar->insertSeparator();
}


void MusicdrawTopLevel::checkMenuAndToolbarEnabling()
{
    bool enable = main_client_widget != 0;
    file_menu->setItemEnabled(menuid_insert, enable);
    file_menu->setItemEnabled(menuid_save, enable);
    file_menu->setItemEnabled(menuid_save_as, enable);
    file_menu->setItemEnabled(menuid_close, enable);
    toolbar->setItemEnabled(toolbarid_save, enable);
}


void MusicdrawTopLevel::setFilename(const char *fn)
{
    filename = fn;
    setCaption(filename + QString(" - ") + PROGRAM_NAME + " Editor");
}


void MusicdrawTopLevel::clearFilename()
{
    filename = "";
    setCaption(VERSION_STRING);
}


/**
  * Returns isEmpty(), if no file was selected.
  */
QString MusicdrawTopLevel::askFilename(const char *title)
{
    filedialog->setCaption(title);
    filedialog->rereadDir();
    filedialog->show();
    if (filedialog->result()) return filedialog->selectedFile();
    else return "";	
}


void MusicdrawTopLevel::setNewMainWidget(MacroModuleEditor *mme)
{
    main_client_widget = mme;

    setView(main_client_widget, true);
    main_client_widget->show();
    createMenu();
    main_client_widget->addToolbarButtons(toolbar);
    statusbar = new KStatusBar(this);
    main_client_widget->addStatusbarItems(statusbar);
    setStatusBar(statusbar);
    enableStatusBar(KStatusBar::Show);
    show();
}


bool MusicdrawTopLevel::removeCurrentMainWidget()
{
    if (main_client_widget) {
	if (!main_client_widget->preparedToDie()) return false;
	main_client_widget->removeToolbarButtons();
	setStatusBar(0); // TODO: Does this work?. Must I delete the old statusbar?
	delete statusbar;
	resize(splashscreen->size() + QSize(0, 51));
	setView(splashscreen);
	delete main_client_widget;
	main_client_widget = 0;
	delete macro_module_look;
	delete macro_module;
    }
    createMenu();
    return true;
}


void MusicdrawTopLevel::openOrInsert(bool open)
{
    QString fn = askFilename(open ? l_SELECT_FILE_TO_OPEN : l_SELECT_FILE_TO_INSERT);
    if (!fn.isEmpty())
    {
	openOrInsert(open, fn);
    }
}

void MusicdrawTopLevel::openOrInsert(bool open, QString filename)
{
    if (!open || removeCurrentMainWidget()) 
    {
	InputModuleFile modulefile(filename);
	if (!modulefile.isGood()) {
	    cerr << "Can't open " << filename << " for input." << endl;
	}
	else {
	    if (open) {
		macro_module = new MacroModule(MacroModule::ET_TOPLEVEL,"",&modulefile);
		macro_module_look = 
		    new MacroModuleLook(this, macro_module);
		setNewMainWidget(new MacroModuleEditor(this, macro_module_look));
		setFilename(filename);
	    }
	    else main_client_widget->insertFile(modulefile);
	}
    }
}


// ===========================================================================
//
//                               events
//
// ===========================================================================


void MusicdrawTopLevel::keyPressEvent(QKeyEvent *e)
{
    if (main_client_widget) main_client_widget->keyPressed(e);
}


// ===========================================================================
//
//                               slots
//
// ===========================================================================

void MusicdrawTopLevel::neww()
{
    if (removeCurrentMainWidget())
    {
	macro_module =  new MacroModule(MacroModule::ET_TOPLEVEL, "");
	macro_module_look = new MacroModuleLook(this, macro_module);
        setNewMainWidget(new MacroModuleEditor(this, macro_module_look));
	setFilename(l_DEFAULT_FILENAME);
    }
}


void MusicdrawTopLevel::save() // private slot
{
    if (main_client_widget) {
	OutputModuleFile modulefile(filename);
	if (modulefile.isGood()) main_client_widget->saveToFile(modulefile, true);
	else cerr << "Can't save to file " << filename << endl; // TODO: Messagebox
    }
}


void MusicdrawTopLevel::saveAs() // private slot
{
    QString filename = askFilename(l_SELECT_FILE_TO_SAVE);
    if (!filename.isEmpty()) {
	setFilename(filename);
	save();
    }
}


void MusicdrawTopLevel::close() // public slot
{
    removeCurrentMainWidget();
    clearFilename();
}


void MusicdrawTopLevel::quit() // public slot
{
    if (removeCurrentMainWidget()) application->quit();
}

void MusicdrawTopLevel::help()
{
    KApplication::getKApplication()->invokeHTMLHelp("mmm/index.html", "");
}


void MusicdrawTopLevel::about()
{
    QMessageBox::message( "About", \
			  VERSION_STRING " by Mathias Kettner\n" \
			  "Copyright 1998", 
			  "Thank You!");
}


void MusicdrawTopLevel::examples()
{
//    KFileDialog filedialog(global_examples_dir, "*.md|Mathi's Music Magic Module", 
//			       0, "file_dialog", true, false);

    QFileDialog filedialog(global_examples_dir, "*.md", 0, "", true);
    
    filedialog.setCaption("Feel free to choose an example to open");
    filedialog.rereadDir();
    filedialog.show();
    if (filedialog.result()) {
	openOrInsert(true, filedialog.selectedFile());
    }
}
