#include "SamplingConfigDialog.h"
#include "SamplingConfigDialog-moc.h"
#include "SamplingConfig.h"

#include <qlayout.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qslider.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

#include <kapp.h>
#include <stdlib.h>

const char *srname[NUM_SAMPLING_RATES] =
{ "48000", "44100", "22050", "16000", "11025", "8000", "6666", "5000", "4000" };

const int srrate[NUM_SAMPLING_RATES] = 
{ 48000, 44100, 22050, 16000, 11025, 8000, 6666, 5000, 4000 };

SamplingConfigDialog::SamplingConfigDialog(SamplingConfigExt *config)
    : QDialog(0, "samplingconfig", TRUE)
    , config(config)
{
    setCaption("Sampling Configuration");
    
    // Contruct layout tree
    QVBoxLayout *toplayout = new QVBoxLayout(this, 4, 4);

    // Data 
    QHBoxLayout *ly_data = new QHBoxLayout(3);
    toplayout->addLayout(ly_data, 1);

    // Sampling rate
    w_samplingrates     = new QButtonGroup(this);
    w_samplingrates->setTitle(i18n("Rate"));
    ly_data->addWidget(w_samplingrates, 2);
    QVBoxLayout *ly_samplingrates = new QVBoxLayout(w_samplingrates, 2);
    ly_samplingrates->addSpacing(w_samplingrates->fontMetrics().height());
    for (int b=0; b<NUM_SAMPLING_RATES; b++) {
	w_samplingrate[b] = new QRadioButton(w_samplingrates);
	w_samplingrate[b]->setText(srname[b]);
	w_samplingrate[b]->setChecked(b==0);
	ly_samplingrates->addWidget(w_samplingrate[b]);
	w_samplingrate[b]->setMinimumSize(w_samplingrate[b]->sizeHint());
    }
    ly_samplingrates->activate();

    // right part
    QVBoxLayout *ly_right = new QVBoxLayout(3);
    ly_data->addLayout(ly_right, 3);

    // Bit size
    w_samplesizes = new QButtonGroup(this);
    w_samplesizes->setTitle(i18n("Bits/Sample"));
    ly_right->addWidget(w_samplesizes, 0);
    QVBoxLayout *ly_samplesizes = new QVBoxLayout(w_samplesizes, 2);
    ly_samplesizes->addSpacing(w_samplesizes->fontMetrics().height());
    for (int b=0; b<2; b++) {
	w_samplesize[b] = new QRadioButton(w_samplesizes);
	w_samplesize[b]->setText(b==0 ? "8 Bit" : "16 Bit");
	w_samplesize[b]->setChecked(b == 1);
	ly_samplesizes->addWidget(w_samplesize[b]);
	w_samplesize[b]->setMinimumSize(w_samplesize[b]->sizeHint());
    }
    ly_samplesizes->activate();

    // Write ahead
    QGroupBox *box_writeahead = new QGroupBox(this);
    box_writeahead->setTitle(i18n("Compute ahead"));
    box_writeahead->setFrameStyle(QFrame::Box | QFrame::Sunken);
    ly_right->addWidget(box_writeahead, 1);
    QVBoxLayout *vbox = new QVBoxLayout(box_writeahead, 3);
    vbox->addSpacing(box_writeahead->fontMetrics().height());
    QHBoxLayout *ly_writeahead = new QHBoxLayout(6);
    vbox->addLayout(ly_writeahead);
//    ly_writeahead->addSpacing(box_writeahead->fontMetrics().height());
    w_writeahead= new QSlider(1, 16, 1, 0, QSlider::Horizontal, box_writeahead);
    w_writeahead->setTracking(TRUE);
    connect(w_writeahead, SIGNAL(sliderMoved(int)), this, SLOT(writeaheadChanged(int)));
    w_writeahead->setMinimumSize(w_writeahead->sizeHint());
    w_writeahead->setFixedHeight(w_writeahead->sizeHint().height());
    w_writeahead->setFixedWidth(151);
    w_writeahead->setTickmarks(QSlider::Below);
    l_writeahead= new QLabel(w_writeahead, "4", box_writeahead);
    l_writeahead->setMinimumSize(l_writeahead->sizeHint());
    l_writeahead->setFixedWidth(box_writeahead->fontMetrics().height() * 3);
    ly_writeahead->addWidget(l_writeahead);
    ly_writeahead->addStretch(1);
    ly_writeahead->addWidget(w_writeahead);
    vbox->activate();

    // Fragment size
    QGroupBox *box_fragmentsize = new QGroupBox(this);
    box_fragmentsize->setTitle(i18n("Fragment size"));
    box_fragmentsize->setFrameStyle(QFrame::Box | QFrame::Sunken);
    ly_right->addWidget(box_fragmentsize, 1);
    vbox = new QVBoxLayout(box_fragmentsize, 3);
    vbox->addSpacing(box_fragmentsize->fontMetrics().height());
    QHBoxLayout *ly_fragmentsize = new QHBoxLayout(6);
    vbox->addLayout(ly_fragmentsize);
    //   ly_fragmentsize->addSpacing(box_fragmentsize->fontMetrics().height());
    w_fragmentsize= new QSlider(4, 19, 1, 0, QSlider::Horizontal, box_fragmentsize);
    w_fragmentsize->setTracking(TRUE);
    connect(w_fragmentsize, SIGNAL(sliderMoved(int)), this, SLOT(fragmentsizeChanged(int)));
    w_fragmentsize->setMinimumSize(w_fragmentsize->sizeHint());
    w_fragmentsize->setFixedHeight(w_fragmentsize->sizeHint().height());
    w_fragmentsize->setFixedWidth(151);
    w_fragmentsize->setTickmarks(QSlider::Above);
    l_fragmentsize= new QLabel(w_fragmentsize, "4", box_fragmentsize);
    l_fragmentsize->setMinimumSize(l_fragmentsize->sizeHint());
    l_fragmentsize->setFixedWidth(box_fragmentsize->fontMetrics().height() * 3);
    ly_fragmentsize->addWidget(l_fragmentsize);
    ly_fragmentsize->addStretch(1);
    ly_fragmentsize->addWidget(w_fragmentsize);
    vbox->activate();

    // Frags per display refresh
    QGroupBox *box = new QGroupBox(this);
    box->setTitle(i18n("Display refresh rate"));
    box->setFrameStyle(QFrame::Box | QFrame::Sunken);
    ly_right->addWidget(box, 1);
    vbox = new QVBoxLayout(box, 3);
    vbox->addSpacing(box->fontMetrics().height());
    QHBoxLayout *hbox = new QHBoxLayout(6);
    vbox->addLayout(hbox);
    w_frags_per_display_refresh = new QSlider(0, 15, 1, 0, QSlider::Horizontal, box);
    w_frags_per_display_refresh->setTracking(TRUE);
    connect(w_frags_per_display_refresh, SIGNAL(sliderMoved(int)), this, SLOT(fpdrChanged(int)));
    w_frags_per_display_refresh->setMinimumSize(w_frags_per_display_refresh->sizeHint());
    w_frags_per_display_refresh->setFixedHeight(w_frags_per_display_refresh->sizeHint().height());
    w_frags_per_display_refresh->setFixedWidth(151);
    w_frags_per_display_refresh->setTickmarks(QSlider::Above);
    l_frags_per_display_refresh= new QLabel(w_frags_per_display_refresh, "", box);
    l_frags_per_display_refresh->setMinimumSize(l_frags_per_display_refresh->sizeHint());
    l_frags_per_display_refresh->setFixedWidth(box->fontMetrics().height() * 3);
    hbox->addWidget(l_frags_per_display_refresh);
    hbox->addStretch(1);
    hbox->addWidget(w_frags_per_display_refresh);
    vbox->activate();

    // Further options
    box = new QGroupBox(this);
    box->setTitle(i18n("Further options"));
    box->setFrameStyle(QFrame::Box | QFrame::Sunken);
    ly_right->addWidget(box);
    vbox = new QVBoxLayout(box, 3);
    vbox->addSpacing(box->fontMetrics().height());
    w_show_seconds = new QCheckBox(box);
    w_show_seconds->setText(i18n("Display seconds"));
    w_show_seconds->setMinimumSize(w_show_seconds->sizeHint());
    vbox->addWidget(w_show_seconds, 0);
    vbox->addStretch(1);
    vbox->activate();

    ly_right->addStretch(5);

    // ----------------------------------------------------------------------
    // OK, Help and Cancel
    QHBoxLayout *ly_okcancel = new QHBoxLayout();
    toplayout->addLayout(ly_okcancel, 0);

    w_okbutton = new QPushButton("OK", this);
    w_okbutton -> setMinimumSize(w_okbutton->sizeHint());
    w_okbutton ->setDefault(true);
    w_helpbutton = new QPushButton(i18n("&Help"), this);
    w_helpbutton -> setMinimumSize(w_helpbutton->sizeHint());
    w_cancelbutton = new QPushButton("Cancel", this);
    w_cancelbutton -> setMinimumSize(w_cancelbutton->sizeHint());

    connect(w_okbutton,        SIGNAL(clicked()), this, SLOT(dataFromWidgets()));
    connect(w_okbutton,        SIGNAL(clicked()), this, SLOT(accept()));
    connect(w_helpbutton,      SIGNAL(clicked()), this, SLOT(help()));
    connect(w_cancelbutton,    SIGNAL(clicked()), this, SLOT(reject()));

    ly_okcancel->addWidget(w_okbutton);
    ly_okcancel->addWidget(w_helpbutton);
    ly_okcancel->addStretch(1);
    ly_okcancel->addSpacing(12);
    ly_okcancel->addWidget(w_cancelbutton);

    dataToWidgets();

    toplayout->activate();
    resize(0,0);
}


void SamplingConfigDialog::help()
{
    printf("Help.\n");
}


void SamplingConfigDialog::dataToWidgets()
{
    w_samplingrate[0]->setChecked(TRUE);
    for (int sr=0; sr<NUM_SAMPLING_RATES; sr++)
	if (config->samplingrate == srrate[sr]) w_samplingrate[sr]->setChecked(TRUE);

    w_samplesize[config->samplesize == 8 ? 0 : 1]->setChecked(TRUE);
    w_writeahead->setValue(config->writeahead);
    writeaheadChanged(config->writeahead);
    fragmentsizeChanged(config->fragmentsize);
    fpdrChanged(config->frags_per_display_refresh);
    w_fragmentsize->setValue(config->fragmentsize);
    w_frags_per_display_refresh->setValue(config->frags_per_display_refresh);
    w_show_seconds->setChecked(config->show_seconds);
}


void SamplingConfigDialog::dataFromWidgets()
{
    for (int sr=0; sr<NUM_SAMPLING_RATES; sr++)
	if (w_samplingrate[sr]->isChecked()) config->samplingrate = srrate[sr];
    config->samplesize   = w_samplesize[0]->isChecked() ? 8 : 16;
    config->writeahead   = w_writeahead->value();
    config->fragmentsize = w_fragmentsize->value();
    config->frags_per_display_refresh = w_frags_per_display_refresh->value();
    config->show_seconds = w_show_seconds->isChecked();
}


void SamplingConfigDialog::writeaheadChanged(int value)
{
    QString string;
    string.sprintf("%d",  value);
    l_writeahead->setText(string);
}

void SamplingConfigDialog::fragmentsizeChanged(int value)
{
    QString string;
    if (value < 10) string.sprintf("%ld",  1L << value);
    else            string.sprintf("%ldk", 1L << value - 10);
    l_fragmentsize->setText(string);
}

void SamplingConfigDialog::fpdrChanged(int value)
{
    QString string;
    if (value < 10) string.sprintf("1/%ld",  1L << value);
    else            string.sprintf("1/%ldk", 1L << value - 10);
    l_frags_per_display_refresh->setText(string);
}
