// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/WireLook.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#include "WireLook.h"
#include "Wirebox.h"
#include "Wire.h"
#include "Slot.h"
#include "ModuleLook.h"

extern const int NUMBER_WIRE_COLORS;

WireLook::WireLook(const ModuleLook *ml0, const ModuleLook *ml1, Wire *w)
    : wire(w)
    , color(preferredColor())
{
    module_look[0] = ml0;
    module_look[1] = ml1; 
}


short WireLook::preferredColor() const
{
    return ((Slot *)wire->getSlot())->getWireColor();
}


QRect WireLook::nicelyWireIntoWirebox(Wirebox *wirebox)
{
    QRect updaterect;
    path = wirebox->nicelyLayoutWire(module_look[0], module_look[1], color,
				     gridposition[0], gridposition[1], updaterect);
    return updaterect;
}


QRect WireLook::ripOutOfWirebox(Wirebox *wirebox)
{
    return wirebox->harshlyRipoutWire(gridposition[0], path, color);
}


bool WireLook::isConnectedTo(const ModuleLook *ml) const
{
    return wire->isConnectedTo(ml->getModule());
}


bool WireLook::isConnectedTo(const Connector *c) const
{
    return c == wire->getSlot() || c == wire->getSignal();
}
