// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/Wirebox.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#ifndef Wirebox_h
#define Wirebox_h

#include "Wirecell.h"

typedef unsigned short Cost; // For searching "shortest" path
const Cost MAX_COST = 65535; // For searching "shortest" path

class ModuleLook;

class Wirebox
{
    /**
     * Size of the Wirebox measured in cells.
     */
    QSize size;
    
    /**
     * Two-dimensional array holding the cells.
     */
    Wirecell **aa_wirecell;

    /**
     * Two-dimensional array holding locked cells. A locked cell is one
     * where no wire should be layouted through. In praxis locked regions
     * are the places where LayoutElement (Modules) are placed. No wire should
     * cross a module, if there is another way to layout it. Locking is nested.
     */
    unsigned short **aa_locked;
    
public:
    Wirebox(QSize size);
    ~Wirebox();
    QString nicelyLayoutWire(const ModuleLook *from,  const ModuleLook *to, short color,
			     QPoint& gridpos_from, QPoint& gridpos_to, QRect& updaterect);
    QRect harshlyRipoutWire(const QPoint& from, QString path, short color);

    /**
     * Paints a part of the Wirebox.
     * @param rect The part that is to paint in pixel (not grid) choords.
     */
    void paint(QPainter& p, const QRect& rect);

    void lockRegion(const QRect& rect, bool lock_or_release=true);
    void releaseRegion(const QRect& rect) { lockRegion(rect, false); };

private:
    enum Direction { LEFT='W', RIGHT='E', UP='N', DOWN='S' };
    void layWire(const QPoint& gridpos, Direction, Colormask colormask);
    Direction directionFromTo(const QPoint& from, const QPoint& to) const;
    /**
     * Finds the @ref #Wirecell and the @ref Wirecell#direction where a piece
     * of wire is stored.
     */
    Wirecell& findWirecell(const QPoint& from, const QPoint& to, 
			   Wirecell::Direction& direction) const;
    Cost costFromTo(const QPoint& from, const QPoint& to, Colormask colormask) const;
    Cost costForTouching(const QPoint& gridpos, Colormask colormask) const;
    Cost costForTouching(short x, short y, Wirecell::Direction wd, Colormask cmask) const;
    Cost optimalCost(const QPoint& from, const QRect& to) const;
};

#endif // Wirebox_h
