#include "MScalarDisplay.h"
#include "LookMacros.h"

class MLDigitalScalarDisplay : public ModuleLook
{
    string last_string;
public:
    MLDigitalScalarDisplay(Module *module, ModuleLookGenerator *mlg) 
	: ModuleLook(module, mlg) {};
    static string getString(Number value);
    bool needsRepaint();
};

class MLGDigitalScalarDisplay : public ModuleLookGenerator
{
public:
    ModuleLook *create(Module *module) { return new MLDigitalScalarDisplay(module, this); };
    string getName() const { return "digital-scalar-display"; };
    const char *menuPath() const { return "Display/Scalar"; }
    QSize gridSize() const { return QSize(4,1); };
    void paint(QPainter&, Module *);
};

MLGDigitalScalarDisplay mlg_DigitalScalarDisplay;

// ----------------------------------------------------------------------

string MLDigitalScalarDisplay::getString(Number value)
{
    static char s[32];
    sprintf(s, "%5.2f", value);
    return string(s);
}

bool MLDigitalScalarDisplay::needsRepaint()
{
    Number value = ((MScalarDisplay *)getModule())->getValue();
    string string = getString(value);
    if (last_string != string) {
	last_string = string;
	return true;
    }
    else return false;
}


void MLGDigitalScalarDisplay::paint(QPainter& p, Module *module)
{
    Number value = module ? ((MScalarDisplay *)module)->getValue() : 0.00;
    string string = MLDigitalScalarDisplay::getString(value);
    
    QRect textbox(QPoint(0,0), size()); // pos is in pixles
    p.setBackgroundColor(black);
    p.eraseRect(textbox);
    p.setPen(QColor(255,220,64));
    p.drawText(textbox, AlignRight | AlignVCenter, string.c_str());
}
