// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MBinaryArithmeticOperator.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

// BAO means: BinaryArithmeticOperator

#include <math.h>

#include "ModuleMacros.h"

typedef bool((*OPERATOR_FUNCTION)(Number, Number, Number&));

bool operator_plus (Number in1, Number in2, Number& ret) { ret = in1 + in2; return true; };
bool operator_minus(Number in1, Number in2, Number& ret) { ret = in1 - in2; return true; };
bool operator_mult (Number in1, Number in2, Number& ret) { ret = in1 * in2; return true; };
bool operator_div  (Number in1, Number in2, Number& ret) { if (in2 != 0) ret = in1 / in2; return in2 != 0; };
bool operator_pow  (Number in1, Number in2, Number& ret) { ret = pow(in1,in2); return true; };
bool operator_greater(Number in1, Number in2, Number& ret) { ret = (in1 > in2  ? 1 : 0); return true; };
bool operator_smaller(Number in1, Number in2, Number& ret) { ret = (in1 < in2  ? 1 : 0); return true; };
bool operator_equal(Number in1, Number in2, Number& ret) { ret = (in1 == in2  ? 1 : 0); return true; };
bool operator_logical_and(Number in1, Number in2, Number& ret) { ret = (in1 != 0.0 && in2 != 0.0); return true; };
bool operator_logical_or(Number in1, Number in2, Number& ret) { ret = (in1 != 0.0 || in2 != 0.0); return true; };


struct BinaryOperator
{
    OPERATOR_FUNCTION operator_function;
    const char *name;
    const char *description;
    const char *slot_name[2];
    const char *slot_description[2];
    Number defaultvalue[2];
};

#define NUMBER_OPERATORS 10

const BinaryOperator a_operator[NUMBER_OPERATORS] = { 
    { operator_plus, "plus", "Sum of summand1 and summand2", 
      { "summand1", "summand2"}, { "First number to add", "Second Number to add" },   { 0.0, 0.0 }},

    { operator_minus, "minus", "Difference number1 minus number2", 
      { "number1", "number2"},   { "Number to subtract from", "Number to subtract" }, { 0.0, 0.0 }},

    { operator_mult, "mult", "Product of factor1 and factor2", 
      { "factor1", "factor2"},   { "First factor", "Second factor" },                 { 1.0, 1.0 }},

    { operator_div, "div", "Quotient dividend / divisor",
      { "dividend", "divisor"}, { "Number to divide", "Number to divide by" },        { 1.0, 1.0 }},

    { operator_pow, "pow", "base to the power of exponent", 
      { "base", "exponent"}, { "Base", "Exponent" },                                  { 1.0, 1.0 }},

    { operator_greater, "greater", "1 if input1 > input2, 0 otherwise", 
      { "number1", "number2"}, { "Number 1", "Number 2" },                            { 0.0, 0.0 }},

    { operator_smaller, "smaller", "1 if input1 < input2, 0 otherwise", 
      { "number1", "number2"}, { "Number 1", "Number 2" },                            { 0.0, 0.0 }},

    { operator_equal, "logical-equal", "1 if input1 = input2, 0 otherwise", 
      { "number1", "number2"}, { "Number 1", "Number 2" },                            { 0.0, 0.0 }},

    { operator_logical_and, "logical-and", "1 if both numbers are not 0, 0 otherwise",
      { "number1", "number2"}, { "Number 1", "Number 2" },                            { 0.0, 0.0 }},

    { operator_logical_or, "logical-or", "1 if one number is not 0, 0 otherwise",
      { "number1", "number2"}, { "Number 1", "Number 2" },                            { 0.0, 0.0 }}
};


class MBAO : public Module
{
public:
    Slot *nslot_input1;
    Slot *nslot_input2;
    const BinaryOperator *binary_operator;
    MBAO(short op_number);
    string getName() const { return binary_operator->name; };
};

class MGBAO : public ModuleGenerator		
{
    short op_number;
public:
    MGBAO(short op_number) : op_number(op_number) {};
    Module *create(string par) const	{ return new MBAO(op_number); };
    string getName() const { return a_operator[op_number].name; };
};							

MGBAO mg_bao[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };

class PNSBAOOutput : public PreparedNumberSignal
{
    PreparedNumberSignal *pnsig_input1;
    PreparedNumberSignal *pnsig_input2;
    const BinaryOperator *binary_operator;
public:
    PNSBAOOutput(PreparedNumberSignal *pnsig_input1,
		 PreparedNumberSignal *pnsig_input2,
		 const BinaryOperator *binary_operator) :
	pnsig_input1(pnsig_input1), pnsig_input2(pnsig_input2), binary_operator(binary_operator) {};
    virtual ~PNSBAOOutput() { delete pnsig_input1; delete pnsig_input2; };
    Number getNumber();
};


class NSBAOOutput : public Signal
{
public:
    NSBAOOutput(Module *m)
	: Signal(NUMBER_TYPE, "result", ((MBAO *)m)->binary_operator->description, m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

MBAO::MBAO(short op_number)
    : binary_operator(&a_operator[op_number])
{
    addConnector(nslot_input1 = new Slot
		 (NUMBER_TYPE, binary_operator->slot_name[0], binary_operator->slot_description[0],this,8));
    addConnector(nslot_input2 = new Slot
		 (NUMBER_TYPE, binary_operator->slot_name[1], binary_operator->slot_description[1],this,9));
    addConnector(new NSBAOOutput(this));
}


PreparedSignal *NSBAOOutput::prepareSignal(Metainfo *, const Parameterset *)
{
    const BinaryOperator *binary_operator = ((MBAO *)getModule())->binary_operator;
    PreparedNumberSignal *pnsig_input1 = 
	getPreparedNumberSignal(this, ((MBAO *)getModule())->nslot_input1, binary_operator->defaultvalue[0]);
    PreparedNumberSignal *pnsig_input2 = 
	getPreparedNumberSignal(this, ((MBAO *)getModule())->nslot_input2, binary_operator->defaultvalue[1]);
    return new PNSBAOOutput(pnsig_input1, pnsig_input2, binary_operator);
}


Number PNSBAOOutput::getNumber()
{
    Number result;
    if (binary_operator->operator_function(pnsig_input1->getNumber(), pnsig_input2->getNumber(), result))
	return result;
    else return 0.0; // TODO: handle and show error.
}
