// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MTriangle.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "triangle";

#include "ModuleMacros.h"

BEGIN_MODULE_DEFINITION(Triangle);
    Slot *nslot_pitch;
END_MODULE_DEFINITION(Triangle);

class SSigTriangleOutput : public Signal
{
public:
  SSigTriangleOutput(Module *m) : Signal(SOUND_TYPE, "output", "triangle shaped sound", m) {};
  PreparedSignal *prepareSignal(Metainfo*, const Parameterset*);
};


class PSSigTriangleOutput : public PreparedSoundSignal
{
    PreparedNumberSignal *pnsig_pitch;
    Number sampling_interval;
    Number phase;
public:
    PSSigTriangleOutput(PreparedNumberSignal *pnsig_pitch, Number sampling_interval) 
	: pnsig_pitch(pnsig_pitch), sampling_interval(sampling_interval), phase(-0.25) {};
    ~PSSigTriangleOutput() { delete pnsig_pitch; };
protected:
    void computeSamples(Number *, long start_time, long nsamples);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

#include <math.h>
#include "NullSound.h"

MTriangle::MTriangle(string)
{
    addConnector(nslot_pitch = new Slot(NUMBER_TYPE, "pitch", "Frequency in Hz", this, 12));
    addConnector(new SSigTriangleOutput(this)); 
}


PreparedSignal *SSigTriangleOutput::prepareSignal(Metainfo *mi, const Parameterset *parset)
{
    mi->clear();
    Seconds sampling_interval = getSamplingInterval(getModule(), mi, parset);
    if (sampling_interval <= 0) return NullSound::getPreparedNullSignal(mi, parset);
    
    Slot *nslot_pitch = ((MTriangle *)getModule())->nslot_pitch;
    return new PSSigTriangleOutput(getPreparedNumberSignal(this, nslot_pitch, 440.0), sampling_interval);
}


void PSSigTriangleOutput::computeSamples(Number *output,
					 long start_time, long number_of_samples)
{
    Number pitch = pnsig_pitch->getNumber();
    if (pitch <= 0) pitch = 1; // TODO: handle this error! Bring up Annotation.

    Number cycles_per_sample = pitch * sampling_interval;
    
    //    Number phase = start_time * cycles_per_sample - 0.25; // TODO: try to keep phase information
    phase -= floor(phase); // bring in between [0,1[
    while (number_of_samples--) {
	Number l = 4*phase - 1;
	*output++ = l > 1 ? 2-l : l;
	phase += cycles_per_sample;
	if (phase >= 1) phase -= floor(phase);
    }
}
