#ifndef DSPOUT_H_INCLUDED
#define DSPOUT_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/soundcard.h>

#include <defines.h>

class dspout {
private:
	char devname[ 256 ];

	// Audio buffer
	sample_t *audio_buf;
	int buffsize; // in sample_t's

#ifdef USE_FLOATS
	SWORD *output_buf;
#endif

	int audio_fd;   // The fd of the audio device
	int format;     // I should have an enum for what this means
	int rate;       // Sampling rate (in frames/second)
	int channels;   // Stereo or Mono
	int totalfrags; // Number of fragments (total)
	int gotfrags;   // Number of fragments allocated

public:
	dspout( int devnum );
	dspout( const char *filename ); // filename MUST be valid
	~dspout();

	static int numDevs();

	// Error Codes
	enum ErrorCode {
		NoError,
		DeviceBusy,
		DeviceNoGood };

private:
	ErrorCode lasterror;

public:
	ErrorCode getLastError() const { return lasterror; };

	// Audio Format
	enum {	MuLaw    = AFMT_MU_LAW,
		ALaw     = AFMT_A_LAW,
		ADPCM    = AFMT_IMA_ADPCM,
		U8       = AFMT_U8,
		S8       = AFMT_S8,
		S16_LE   = AFMT_S16_LE,  // Little endian signed 16bit
		S16_BE   = AFMT_S16_BE,  // Big endian
		U16_LE   = AFMT_U16_LE,
		U16_BE   = AFMT_U16_BE,
		MPEG     = AFMT_MPEG };  // MPEG 2 audio

	// Channels
	enum {	Mono     = 0,
		Stereo   = 1 };

	void setFragmentInfo( unsigned int numfrags, unsigned int size );
	void setFormat( int fcode );
	void setChannels( int sstereo );
	void setSampleRate( int rrate );

	void printInfo();

	void writeBuffer();
	void flushBuffer();

	inline sample_t *getBuffer() { return audio_buf; };

	inline int getBuffsize() const { return buffsize; };
	inline int getSampleRate() const { return rate; };
	inline int getFd() const { return audio_fd; };
	inline int getNumFrags() const { return totalfrags; };
	inline int getNumChannels() const { return channels; };

	unsigned int bytesPlayed() const;
	unsigned int writeableFragments() const;
};

#endif  // DSPOUT_H_INCLUDED
