#include <taglines.h>
#include <thud.h>
#include <thud.moc>
#include "pics/playstart.xpm"
#include "pics/play.xpm"
#include "pics/stop.xpm"
#include "pics/rev.xpm"
#include "pics/for.xpm"

Thud::Thud( QWidget *parent, const char *name )
	: KTMainWindow( name )
{
	dcontrol = new dspcontrol;
	dcontrol->run();

	gsong->setLoopPoints( 0, 1 );
	gsong->setLoop( true );

	QPopupMenu *file_menu = new QPopupMenu();
	file_menu->insertItem( i18n( "E&xit" ), kapp, SLOT( quit() ) );

	QPopupMenu *help_menu = new QPopupMenu();
	help_menu->insertItem( i18n( "&Help" ), this, SLOT( invokeHelp() ) );

	menuBar = new KMenuBar( this, "menubar" );
	menuBar->insertItem( i18n( "&File" ), file_menu );
	menuBar->insertItem( i18n( "&Help" ), help_menu );

	setMenu( menuBar );

	toolBar = new KToolBar( this );
	addToolBar( toolBar );
	QObject::connect( toolBar, SIGNAL( clicked( int ) ), this, SLOT( toolButtonClicked( int ) ) );

	toolBar->insertButton( QPixmap( (const char **) playstart_xpm ), PlayFromStartButton, true );
	toolBar->insertButton( QPixmap( (const char **) play_xpm ), PlayButton, true );
	toolBar->setToggle( PlayButton, true );
	toolBar->insertButton( QPixmap( (const char **) stop_xpm ), StopButton, true );
	toolBar->insertButton( QPixmap( (const char **) rev_xpm ), RewindButton, true );
	toolBar->insertButton( QPixmap( (const char **) for_xpm ), ForwardButton, true );

	toolBar->insertSeparator( ButtonSeparator1 );

	bpmselector = new BBPMSelect( toolBar );
	toolBar->insertWidget( BPMWidget, bpmselector->width(), bpmselector );

	toolBar->insertSeparator( ButtonSeparator2 );

	songpos = new BSongPosition( toolBar );
	toolBar->insertWidget( SongPosition, songpos->width(), songpos );

	toolBar->insertSeparator( ButtonSeparator3 );

	device = new LittleDeviceButton( toolBar );
	toolBar->insertWidget( SetDevice, device->width(), device );

	statusBar = new KStatusBar( this );
	setStatusBar( statusBar );

	statusBar->message( Taglines::randomTagline() );

  	grid = new ThudGrid( this );
  	setView( grid );
}

Thud::~Thud()
{
	delete dcontrol;
	delete grid;
}

void Thud::invokeHelp()
{
	kapp->invokeHTMLHelp("thud/thud.html", "");
}

void Thud::toolButtonClicked( int id )
{
	switch ( id ) {
		case PlayFromStartButton:
			printf( "Hit PlayFromStart\n" );
			break;;
		case PlayButton:
			if ( toolBar->isButtonOn( PlayButton ) ) {
				gsong->startSong();
			} else {
				gsong->stopSong();
			}
			break;;
		case StopButton:
			gsong->stopSong();
			toolBar->setButton( PlayButton, false );
			break;;
		default:
			break;;
	}
}

