#ifndef TOGGLEPIXMAP_H
#define TOGGLEPIXMAP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qcheckbox.h>
#include <qpixmap.h>

class TogglePixmap : public QCheckBox
{
	Q_OBJECT
public:
	TogglePixmap( QWidget *parent, const char *name, QPixmap *on_kp, QPixmap *off_kp );

	void setState( bool newstate ) { setChecked( newstate ); }

protected:
	void drawButton( QPainter *paint );

protected:
	QPixmap *onPixmap;
	QPixmap *offPixmap;
};

class WatcherTogglePixmap : public TogglePixmap
{
	Q_OBJECT
public:
	WatcherTogglePixmap( QWidget *parent, const char *name, QPixmap *on_kp, QPixmap *off_kp );

private:
	int *watchptr;

public:
	void setUpdatePointer( int *newptr ) { watchptr = newptr; }

public slots:
	void togged( bool newstate );
};

#endif // TOGGLEPIXMAP_H
