//-> Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)
/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
//<-

//-> definitions
//#define withTVscreen
//<-

//-> includes
#include <stdio.h>
#include <stdlib.h>

#include "wintv.h"



#include "xrwevent.h"
#include "wintvmain.h"  // immer in dieser Reihenfolge...
#if defined  HAVE_VTX || HAVE_VBI 
#include <winvtxmain.h>
#endif
#include "wintvchannel.h"
#include "wintvvclip.h"

#include <kapp.h>
#include <parsecl.h>

// X11 stuff
#include <X11/Xlib.h>
#ifdef X11DEBUG
#include "xeventtype.h"
#endif
//<-


//-> class TVApplication: public KApplication
class TVApplication: public KApplication
{
  Q_OBJECT

public:
  TVApplication( int & argc, char ** argv );
  ~TVApplication();

  bool x11EventFilter( XEvent * );
  void setFilterObject(QObject *theObject) { winTVscreenObject = theObject; } 

public slots:
  void shutDownSLOT();
  void sessionManagerSLOT();

private:
  void destroyTV();

  QObject *winTVscreenObject;

  rcfile *rc;
  parsecl *pcl;

  winTVChannelWidget *winTVChannel;
  winTVVClipWidget *winTVVClip;
  winTVMainWidget *winTVMain;
  winMixer *winTVMixer;
#if defined  HAVE_VTX || HAVE_VBI 
  winVTXMainWidget *winVTXMain;
#endif
};
//<-

TVApplication::TVApplication( int & argc, char ** argv ) : KApplication( argc, argv ) 
{
#ifdef myDEBUG
  debug("parse command line ...");
#endif

  pcl= new parsecl( argc, argv );
  pcl->addOption(OP_BPP,"-b","--bpp","n","color depth of the display is n (n=8,15,16,24,32)");
  pcl->addOption(OP_PAL,"-p","--palette","n","set palette of display (see help for details)");
  pcl->addOption(OP_SHI,"-s","--shift","<value>","shift frame buffer (image) by <value> bytes");
  //pcl->addOption(OP_DOK,"-n","--nodock",NULL,"disable docking of TV windwo");
  pcl->addOption(OP_REF,"-r","--refresh","<value>","0: never, 1: smart, 3: clean");
  pcl->addOption(OP_DEV,"-l","--device","<file>","use <file> as video4linux device");
  pcl->addOption(OP_CAP,"-c","--capture","[on|off]","force capture mode to be on or off");
  pcl->addOption(OP_VME,"-x","--no_vme",NULL,"disable XFree extentions (VidMode Extension)");
  
  pcl->parse();

#ifdef myDEBUG
  debug("... loading rc ...");
#endif

  /////////////////////////////////////////////////////////////////////////////
  // load rc-file
  rc=new rcfile();
  rc->load();
  rc->checkVersion();

#ifdef myDEBUG
  debug("TVApplication: init widgets");
#endif
  winTVMixer= new winMixer(rc);
  winTVMain= new winTVMainWidget( pcl, rc, winTVMixer->getVolMixMixerP() );
  winTVChannel= new winTVChannelWidget(NULL,"winTVChannel",rc);
  winTVVClip= new winTVVClipWidget(NULL,"winTVVClip",rc);

  setFilterObject(winTVMain->winTVScreenPtr());
  setMainWidget(winTVMain);

  // connect TVApplication
  connect(this,SIGNAL(shutDown()),this,SLOT(shutDownSLOT()));
 
  // connect winTVMain and winTVChannel
  connect(winTVMain,SIGNAL(channelChangedSIGNAL()),
		   winTVChannel,SLOT(activeChannelChangedSLOT()));
  connect(winTVMain,SIGNAL(newChannelListSIGNAL(QList<channel> *)),
		   winTVChannel,SLOT(newChannelListSLOT(QList<channel> *)));
  connect(winTVMain,SIGNAL(toggleChannelBoxSIGNAL( QPoint * )),
		   winTVChannel,SLOT(toggleVisibilitySLOT( QPoint * )));

  // connect winTVMixer and winTVMain
  connect(winTVMixer,SIGNAL(volChanged(int, int)),
	  winTVMain,SLOT(volumeSLOT(int, int)));
  connect(winTVMixer,SIGNAL(volMuteChanged(bool)),
	  winTVMain,SLOT(volMuteChangedExtSLOT(bool)));
  // connect winTVMain and winTVMixer
  connect(winTVMain,SIGNAL(volumeChangedSIGNAL(int,int)),
	  winTVMixer,SLOT(setVolume(int,int)));
  connect(winTVMain,SIGNAL(volMuteChangedSIGNAL(bool)),
	  winTVMixer,SLOT(volMute(bool)));
  connect(winTVMain,SIGNAL(toggleMixerBoxSIGNAL()),
  	  winTVMixer,SLOT(showMixer()));

  // edit, cut, copy and paste channel
  connect(winTVChannel,SIGNAL(channelSelectedSIGNAL()),
	  winTVMain,SLOT(channelChangedSLOT()));
  connect(winTVChannel,SIGNAL(addChannelSIGNAL()),
	  winTVMain,SLOT(addChannelSLOT()));
  connect(winTVChannel,SIGNAL(editChannelSIGNAL()),
	  winTVMain,SLOT(editChannelSLOT()));
  connect(winTVChannel,SIGNAL(deleteChannelSIGNAL()),
	  winTVMain,SLOT(deleteChannelSLOT()));
  connect(winTVChannel,SIGNAL(copyChannelSIGNAL()),
	  winTVMain,SLOT(copyChannelSLOT()));
  connect(winTVChannel,SIGNAL(pasteChannelSIGNAL()),
	  winTVMain,SLOT(pasteChannelSLOT()));

  // connect winTVMain and winTVVClip
  connect(winTVMain,SIGNAL(toggleVClipSIGNAL()),
		   winTVVClip,SLOT(toggleVClipSLOT()));
  connect(winTVMain,SIGNAL(frameVClipSIGNAL(int)),
		   winTVVClip,SLOT(frameVClipSLOT(int)));
  connect(winTVMain,SIGNAL(framelostVClipSIGNAL(int)),
		   winTVVClip,SLOT(framelostVClipSLOT(int)));
  connect(winTVMain,SIGNAL(statVideoClipFrameSIGNAL(double)),
		   winTVVClip,SLOT(statVideoClipFrameSLOT(double)));

  // connect winTVVClip winTVMain
  connect(winTVVClip,SIGNAL(startVClipSIGNAL(struct MOVIE_PARAMS *)),
		   winTVMain,SLOT(startVClipSLOT(struct MOVIE_PARAMS *)));
  connect(winTVVClip,SIGNAL(endVClipSIGNAL()),
		   winTVMain,SLOT(endVClipSLOT()));

  winTVChannel->setPopup(winTVMain->getChannelMenu());
  winTVMixer->setV4lifP(winTVMain->winTVScreenPtr()->v4lxifP());

  winTVMain->show();

  if ( rc->ol_mix_wasvis ) winTVMixer->show();
  if ( rc->ol_ch_wasvis ) winTVChannel->show();

  winTVMain->emitSetupSignals();

#if defined HAVE_VTX || HAVE_VBI
  winVTXMain= new winVTXMainWidget( pcl );
  winVTXMain->show();
#endif
}


void TVApplication::destroyTV()
{
  setFilterObject(NULL);

  rc->ol_mix_wasvis= winTVMixer->isVisible();
  rc->ol_ch_wasvis= winTVChannel->isVisible();

  delete winTVVClip;
  delete winTVChannel;
  delete winTVMain;
  delete winTVMixer;
#if defined  HAVE_VTX || HAVE_VBI 
  delete winVTXMain;
#endif
  delete rc;
  delete pcl;

#ifdef myDEBUG
  debug("~TVApplication: ~TVApplication end");
#endif
}

TVApplication::~TVApplication()
{
  destroyTV();
}

//-> bool TVApplication::x11EventFilter( XEvent *event)
bool TVApplication::x11EventFilter( XEvent *event )
{
  Window checkw1,checkw2,wwin;

  wwin=DefaultRootWindow(qt_xdisplay());
  checkw1=event->xmap.event;
  checkw2=event->xany.window; 

  if (checkw1 == wwin) {

    X11RWEvent *xrwe = new X11RWEvent(XRWEvent,
				    event->type,
				    event);
    postEvent(winTVscreenObject,xrwe);
    
#ifdef X11DEBUG
    debug("x11EF cwin1 xmap type: %d = %s",event->type,events[event->type]);
#endif

  return TRUE;
  } else if (checkw2 == wwin) {
#ifdef X11DEBUG
  debug("x11EF cwin2 xmap type: %d = %s",event->type,events[event->type]);
#endif
  return TRUE; 
  }

 return FALSE;
}
//<-

void TVApplication::shutDownSLOT()
{
#ifdef myDEBUG
  debug("TVApplication::shutDownSLOT()");
#endif
  destroyTV();
#ifdef myDEBUG
  debug("TVApplication::shutDownSLOT() end");
#endif
}

void TVApplication::sessionManagerSLOT()
{
#ifdef myDEBUG
  debug("sessionManagerSLOT, trying to save rc...");
#endif
}

//-> void myMessageOutput( QtMsgType type, const char *msg )
void myMessageOutput( QtMsgType type, const char *msg )
{
  switch ( type ) {
  case QtDebugMsg:
    fprintf( stderr, "Debug: %s\n", msg );
    break;
  case QtWarningMsg:
    fprintf( stderr, "Warning: %s\n", msg );
    break;
  case QtFatalMsg:
    fprintf( stderr, "Fatal: %s\n", msg );
    //abort();                        // dump core on purpose
    exit(1);
  }
}
//<-

//-> int main( int argc, char **argv )
//
int main( int argc, char **argv )
{
  qInstallMsgHandler( myMessageOutput );

#ifdef myDEBUG
  debug("start ...");
#endif

  KApplication::setColorSpec( KApplication::ManyColor ); 

  TVApplication *winTVApplication= new TVApplication( argc, argv );
  
  winTVApplication->enableSessionManagement( true );
  winTVApplication->setWmCommand(SLOT(sessionManagerSLOT()));

#ifdef myDEBUG
  debug("... runing ...");
#endif

  // main loop
  winTVApplication->exec();

  // the end
  delete winTVApplication;

#ifdef myDEBUG
  debug("... end");
#endif

  return 0;
}
//<-

//-> moc's
#include "wintv.moc"
//<-








