/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef WINTVSCREEN_H
#define WINTVSCREEN_H

#include <wintv.h>
#include <xrwevent.h>

// includes needed by qt
#include <kapp.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qtimer.h>
#include <qdatetm.h> 
#include <qlcdnum.h>
#include <kpopmenu.h>
#define POPUPMENU KPopupMenu
#include <qlabel.h>
#include <qprogressbar.h> 

#include <channel.h>
#include <videoclip.h>      // video clip stuff

#include <v4lxif.h>

//========================= class winTVScreenWidget =====================================

class winTVScreenWidget : public QWidget
{
  
  Q_OBJECT

public:
  winTVScreenWidget( QWidget *_parent=0, const char *name=0,
		     int _capture=0, const char *_bttvdev=V4L_DEVICE, 
		     int _freq=DFREQ, int _input=DNORM );
  ~winTVScreenWidget();
  
  inline int win_default_width(void) { return DEFAULT_WIDTH; }
  inline int win_default_height(void) { return  DEFAULT_HEIGHT; }
  inline int win_max_width(void) { return max_width; }
  inline int win_max_height(void) { return max_height; }
  inline int win_width() { return v4lx->getWWidth(); }
  inline int win_height() { return v4lx->getWHeight(); }

  inline int getScreenSaverState() { return saverState; }
  inline int getCaptureState() { return captureState; }
  inline int getCursorState() { return cursorState; }

  inline int getMute() { return v4lx->getAudioMute(); }
  inline int getAudioMode() { return audioMode; }
  inline int getVolume() { return v4lx->getAudioVolume(); }

  inline int getCanVolume() { return audioVolumeCan; }

  inline void setTVPopup(POPUPMENU *tvp) { tvPopup=tvp; } 

  /**
   * @param allow 1: allowViewRefresh 2: allowViewRefreshVisibility 3: both
   */
  inline void setViewRefreshMode( int allow ) {  
    allowViewRefreshVisibility= allow&2?true:false;
    allowViewRefresh= allow&1?true:false; }

  inline int getViewRefreshMode() 
    { return ((allowViewRefresh?1:0) & (allowViewRefreshVisibility?2:0)); }
    
  inline void setRefreshDelay( int d ) { viewRefreshDelay=d; }
  inline int getRefreshDelay() { return viewRefreshDelay; }

  inline int getShotNumber() { return shotnumber; }

  inline void setPalette( int p ) { if ( p ) v4lx->setPalette( p ); }

  inline v4lxif * v4lxifP() { return v4lx; }

  /* -------------------------------------------------------------------------------------- */
  /* -------------------------------------------------------------------------------------- */
public slots:
  // use this slots to change anything 
  void showOSDSLOT(channel *ch,int val, 
			   int min_val, int max_val, const char *text );
  void showOSDEnableSLOT( int level );

  // capture
  void changeCaptureSLOT(int value);       // toggle capture on/off; init is set by constructor

  // tunig et al
  void changeFrequencySLOT(int value);     // does what its name says ...
  void changeBrightnessSLOT(int bri);      
  void changeContrastSLOT(int contr);
  void changeColorSLOT(int color);
  void changeHueSLOT(int hue);
  void changeSourceSLOT(int s);
  void changeNormSLOT(int n);

  // set all 
  void changeChannelValuesSLOT(channel *c, int id);

   // sound et al
  void toggleAudioMuteSLOT();                 // toggles mute on/off, init is on
  void changeAudioVolumeSLOT(int vl, int vr);     // 
  void changeAudioModeSLOT(int mode);         // init is auto

  // screen saver and mouse cursor
  void toggleScreenSaverSLOT();      // toggles screen saver on/off; init is on
  void toggleMouseCursorSLOT();      // toggles mouse cursor on/off; init is on

  // unused stuff
  void changeTVMultiDisplaySLOT(int x, int y, int w, int h); // not used yet

  // one snap shot
  void snapShotSLOT(const char *prefix, int fixed, int width, int height, int format, int quality);

  // create video clip; format: VIDEOCLIP_AVI, VIDEOCLIP_PPM, VIDEOCLIP_RAW
  void startVideoClipSLOT(struct MOVIE_PARAMS *par); 
  void endVideoClipSLOT();

  void postInit();

  void Shellx11EventSLOT(XEvent *);

  /* -------------------------------------------------------------------------------------- */
  /* -----stop reading --- everything below is private ... -------------------------------- */
  /* -------------------------------------------------------------------------------------- */
private slots:
  void refreshTVActionSLOT();
  void autoDetectAudioModeSLOT();
  void writeVideoClipFrameSLOT();
  void unShowOSDSLOT();
  void setMuteStateAfterFChangeSLOT();

  /* -------------------------------------------------------------------------------------- */
signals:
  void keyPressedSIGNAL(int key);   // returns all keys pressed in winTVScreenWidget
  void autoDetectAudioModeSIGNAL(int mode);
  void wroteVideoClipFrameSIGNAL(int frames);
  void lostVideoClipFrameSIGNAL(int frames);
  void statVideoClipFrameSIGNAL(double);
  void toggleTVonlySIGNAL();

  /* -------------------------------------------------------------------------------------- */
protected:
  void resizeEvent( QResizeEvent * );
  void moveEvent( QMoveEvent * );
  void paintEvent (QPaintEvent * );
  //void closeEvent (QCloseEvent * );
  bool eventFilter( QObject *, QEvent * );
  bool x11Event( XEvent * );
  void keyPressEvent ( QKeyEvent *);
  //void mouseMoveEvent (QMouseEvent *);
  void mouseReleaseEvent ( QMouseEvent * me);

  /* -------------------------------------------------------------------------------------- */
private:
  void capture( int on ); // 1=on 0=off
  void switch_capture( int on ); // switch capture on/off 

  int initializeTV( WId parentWid = 0 );
  void destroyTV();

  void configOverlay();
  void newTVGeometry( bool doViewRefresh );
  void setTVMaxSize();
  void refreshTV();
  int setTVClipTab( int num );
  int getTVClipTab( bool set, int wx=0, int wy=0, unsigned int ww=0, unsigned int wh=0, int xadj=0, int yadj=0);

  void readData();

/* -------------------------------------------------------------------------------------- */
/* ---------------------------- resources ----------------------------------------------- */
/* -------------------------------------------------------------------------------------- */

  QWidget *parent;

  v4lxif * v4lx;            // video4linux interface (v4l, v4l2)

  const char *devname;      // name of the video4linux-device

  // bttv stuff
  int defaultNorm;                // input norm, PAL, NTSC, SECAM
  int defaultFreq;                // frequency, *16 
  int defaultInput;               // input channel, TUNER, COMP1, COMP2, SVHS 
  int viewRefreshDelay;               // 200ms
  int Bright;              // Brightness
  int Color;               // intensity of colors
  int Hue;                 // hue
  int Contrast;            // contrast
  
  bool snap;            // snapshot

  unsigned int max_width;          // max width of TV picture 
  unsigned int max_height;         // max height of TV picture, both set by setTVMaxSize

  int alloc_context;
  QColor qcolors[256];     // colormap, needed when having only 256 colors -> pseudocolor

  bool colorMap8;              // are we using an own colormap ( <= 256 colors)

  QTimer *viewRefreshTimer;
  int newVisibility,lastClipCount;
  bool allowViewRefresh,didViewRefresh,allowViewRefreshVisibility;   
  bool didViewMove,doNewConfig,mapWindow;            // the widget was moved
  bool captureIsOn,captureWasOnQt,captureWasOnX11;          // picture on/off
  int oldxadj,oldyadj;
  int nnewclips,noldclips;
  int widget_is_active;           // the widget is aktive

  QCursor orgCursor;       // Cursor

  QTimer *audioDetectTimer,*muteTimer;
  int audioMode,audioVolumeCan,audioVolume;
  int muteDelay;
  
  int cursorState,saverState,muteState,captureState;

  int ss_timeout,ss_interval,ss_prefer_blanking,ss_allow_exposures; // stuff for ScreenSaver

  int shotnumber;          // number of screen shot, starting at 0

  // popup
  POPUPMENU *tvPopup;

  // video clip stuff
  QTime videoTime;
  videoClip *video;
  int video_aktive, video_capturing;
  bool video_frame;
  long elapsed;

  // info tools
  QLabel *chInfoText;
  QProgressBar *chInfoBar;
  int chInfo;
  QTimer *infoTimer;
  int infodelay;

  // title image
  QPixmap title_pm;
  int title_shown;
};

#endif WINTVSCREEN_H
















