/* $Id: dlgAutomation.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgAutomation.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGAUTOMATION_H
#define _DLGAUTOMATION_H

#include <qgroupbox.h> 
#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <kintegerline.h>

#include "bwdatetime.h"

class DlgAutomation : public QWidget
{
  Q_OBJECT

public:

  DlgAutomation(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~DlgAutomation();

  void setData(QStrList *strList);
  QStrList getData() const;
     
private:

  // auto save settings
  QCheckBox *cb_autoSave;
  QLabel    *lb_autoSave;
  KIntegerLine *le_autoSave;

  // auto disconnect settings
  QCheckBox *cb_autoDisconnect;
  QLabel    *lb_autoDisconnect;
  QLineEdit *le_autoDisconnect;
  QCheckBox *cb_timedDisconnect;
  BWDateTime *spins;

  QDateTime disconnectDateTime;

  // auto shutdown settings
  QCheckBox *cb_autoShutdown;
  
  // auto paste settings
  QCheckBox *cb_autoPaste;

protected slots:
  void disconnectToggled( bool );

};

#endif // _DLGAUTOMATION_H
