/* $Id: dlgConnection.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgConnection.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGCONNECTION_H
#define _DLGCONNECTION_H

#include <qgroupbox.h> 
#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include <kintegerline.h>

class DlgConnection : public QWidget
{
  Q_OBJECT

public:

  DlgConnection(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~DlgConnection();

  void setData(QStrList *strList);
  QStrList getData() const;
     
private:

  // reconnect settings
  QGroupBox *gb_reconnect;

  QCheckBox *cb_onerror;
  QLabel    *lb_after;
  KIntegerLine *le_after;
  QLabel    *lb_minutes1;
  QLabel    *lb_retries;
  KIntegerLine *le_retries;

  QCheckBox *cb_onbroken;

  QCheckBox *cb_autoresume;

  // type settings
  QGroupBox *gb_type;

  QComboBox *cmb_type;
  KIntegerLine *le_linknum;
  QCheckBox *cb_offlinemode;

protected slots:
  void comboActivated( int Index );
 
};

#endif // _DLGCONNECTION_H
