/* $Id$
   $Log$

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qpainter.h>

#include <kapp.h>
#include <kwm.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>

#include "MotifDNDHandler.h"
#include "kmainwidget.h"
#include "droptarget.h"

#define TARGET_WIDTH   60
#define TARGET_HEIGHT  60
#define ICONWIDTH      48
#define ICONHEIGHT     48

DropTarget::DropTarget() : QWidget( 0 )
{

  // read settings
  KConfig *config = kapp->getConfig();
  config->setGroup("Geometry");
  QString dropProperties = config->readEntry("DropGeometry", "" );

  if ( dropProperties != "" )
    setGeometry(KWM::setProperties(winId(), dropProperties));
  else {
    setGeometry( 200, 200, TARGET_WIDTH, TARGET_HEIGHT );
    KWM::setDecoration( winId(), KWM::noDecoration | KWM::staysOnTop | KWM::noFocus );
  }

  b_sticky = KWM::isSticky( winId() );

  // setup mask
  mask.resize( TARGET_WIDTH, TARGET_HEIGHT );
  mask.fill( color0 );
  QPainter p2;
  p2.begin( &mask );
  p2.setBrush( color1 );
  p2.drawRoundRect( 0, 0, 60, 60, 40, 40 );
  p2.end();

  // setup pixmaps
  QString path = kapp->kde_datadir() + "/caitoo/pics/";

  int offsetx = ( TARGET_WIDTH - ICONWIDTH ) / 2;
  int offsety = ( TARGET_HEIGHT - ICONHEIGHT ) / 2;

  QPixmap *tmppix = new QPixmap();
  tmppix->load( path + "target_hand1.xpm" );
  handpix1 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix1->fill(backgroundColor());
  bitBlt( handpix1, offsetx, offsety, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( path + "target_hand2.xpm" );
  handpix2 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix2->fill(backgroundColor());
  bitBlt( handpix2, offsetx, offsety, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( path + "target_hand3.xpm" );
  handpix3 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix3->fill(backgroundColor());
  bitBlt( handpix3, offsetx, offsety, tmppix );
  delete tmppix;

  setBackgroundPixmap( *handpix1 );

  // popup menu for right mouse button
  popupMenu = new QPopupMenu();
  popupMenu->setCheckable( true );

  popupMenu->insertItem(i18n("Restore"), this, SLOT( slotRestore() ) );
  pop_sticky = popupMenu->insertItem(i18n("Sticky"), this, SLOT(toggleSticky()));
  popupMenu->setItemChecked( pop_sticky, b_sticky );
  popupMenu->insertItem(i18n("Preferences"), kmain, SLOT( slotPreferences() ) );
  popupMenu->insertSeparator();
  popupMenu->insertItem(i18n("Quit"), kmain, SLOT( quit() ) );

  // Enable dropping
  setAcceptDrops( true );
  MotifDNDHandler::setAcceptMotifDrops( this );

  // setup drop zone
  KDNDDropZone *myDropZone = new KDNDDropZone(this, DndURL);
  connect( myDropZone, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( slotDropEvent( KDNDDropZone *) ) );

}


DropTarget::~DropTarget() {
  delete handpix1;
  delete handpix2;
  delete handpix3;
  delete popupMenu;
}


void DropTarget::writeSettings() {
  KConfig *config = kapp->getConfig();
  config->setGroup("Geometry");
  config->writeEntry("DropGeometry", KWM::getProperties( drop_target->winId() ) );
  config->sync();
}


void DropTarget::mousePressEvent(QMouseEvent *e) {
  if ( e->button() == LeftButton )
    kmain->slotNormalWindow();

  else if ( e->button() == RightButton )
    popupMenu->popup(QCursor::pos());

  else if ( e->button() == MidButton )
    kmain->pasteTransfer();
}


void DropTarget::resizeEvent( QResizeEvent * )
{
  XShapeCombineMask( x11Display(), winId(), ShapeBounding, 0, 0, mask.handle(), ShapeSet );
}


void DropTarget::slotDropEvent( KDNDDropZone *zone ){
  kmain->slotDropEvent ( zone );
}


void DropTarget::toggleSticky() {
  b_sticky = !b_sticky;
  popupMenu->setItemChecked( pop_sticky, b_sticky );

  KWM::setSticky( winId(), b_sticky );
}


void DropTarget::setAnim( int i1, int i2, int i3, int i4, bool online ) {

  size[0] = i1;
  size[1] = i2;
  size[2] = i3;
  size[3] = i4;

  if ( isVisible() ) {

    if ( !online )
      setBackgroundPixmap( *handpix3 );
    else if ( size[0] == 0 && size[1] == 0 && size[2] == 0 && size[3] == 0 )
      setBackgroundPixmap( *handpix1 );
    else {
      QPixmap pm( *handpix2 );
      QPainter p;
      p.begin( &pm );

//      p.setPen( white );
      for ( int i = 0; i < 4; i++ ) {
	if ( size[i] != 0 ) {
	  int pixels = (int)( ( TARGET_WIDTH - 8 ) * (float)size[i] / 100.0 );
	  if ( size[i] != 100 )
    	      p.fillRect( 4, 4 + ( i*12 ), pixels, 10, blue );
	  else
    	      p.fillRect( 4, 4 + ( i*12 ), pixels, 10, red );
	}
      }

      p.end();
      setBackgroundPixmap( pm );
    }
  }
}


void DropTarget::slotRestore() {

  if ( kmain->getStyle9x() )
    kmain->slotNormalWindow();
  else
    kmain->slotDropTarget();

}
