/* $Id: kgetoptdlg.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kgetoptdlg.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.3  1999/02/07 17:14:40  matt
   updated for new setting dialogs


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _PREFERENCES_H
#define _PREFERENCES_H

#include <qdialog.h>
#include <qtabdialog.h>

class DlgConnection;
class DlgProxy;
class DlgAutomation;
class DlgLimits;
class DlgAdvanced;
class DlgDirectories;
class DlgSystem;


class PreferencesDlg : public QTabDialog
{
  Q_OBJECT

public:

  PreferencesDlg(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~PreferencesDlg();

  // methods to access data
  void setConnectionData(QStrList *strList);
  QStrList dataConnection() const;

  void setProxyData();
  void dataProxy();

  void setAutomationData(QStrList *strList);
  QStrList dataAutomation() const;

  void setLimitsData(QStrList *strList);
  QStrList dataLimits() const;
  
  void setAdvancedData(QStrList *strList);
  QStrList dataAdvanced() const;

  void setDirectoriesData(QStrList *strList);
  QStrList dataDirectories() const;

  void setSystemData(QStrList *strList);
  QStrList dataSystem() const;

  void setFontData(QFont font);
  QFont dataFont() const;

private:

  DlgConnection *conDlg;
  DlgProxy      *prxDlg;
  DlgAutomation *autDlg;
  DlgLimits     *limDlg;
  DlgAdvanced   *advDlg;
  DlgDirectories *dirDlg;
  DlgSystem     *sysDlg;

public slots:

  void helpShow();

};

#endif // _PREFERENCES_H
