#include "kio_manager.h"

#include <string.h>
#include <assert.h>

#include <kapp.h>
#include <kdebug.h>

ProtocolManager* ProtocolManager::s_pManager = 0L;

ProtocolManager::ProtocolManager()
{
  assert( !s_pManager );
  
  s_pManager = this;
}

string ProtocolManager::find( const char *_protocol )
{
  // We dont have KApplication here
  string file = KApplication::kde_bindir().data();
  file += "/kio_";
  file += _protocol;
  
  return file;
}

int
ProtocolManager::getReadTimeout() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  int read_timeout = config.readNumEntry( "ReadTimeout", 15 ); // 15 seconds
  
  return read_timeout;
}


bool
ProtocolManager::getMarkPartial() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  bool mark_partial = config.readBoolEntry( "MarkPartial", true );

  return mark_partial;
}


int
ProtocolManager::getMinimumKeepSize() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  int minimum_keep_size = config.readNumEntry( "MinimumKeepSize", 5000 ); // 5000 bytes

  return minimum_keep_size;
}


bool
ProtocolManager::getAutoResume() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  bool automatic_resume = config.readBoolEntry( "AutoResume", false );

  return automatic_resume;
}


bool
ProtocolManager::getPersistent() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  bool persistent = config.readBoolEntry( "PersistentConnections", true );

  return persistent;
}


bool
ProtocolManager::getUseProxy() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  bool useproxy = config.readBoolEntry( "UseProxy", false );

  return useproxy;
}


QString
ProtocolManager::getHttpProxy() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  QString httpproxy = config.readEntry( "HttpProxy" );

  return httpproxy;
}


QString
ProtocolManager::getNoProxyFor() {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  QString noproxy = config.readEntry( "NoProxyFor" );

  return noproxy;
}


void ProtocolManager::setReadTimeout( int _timeout ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "ReadTimeout", _timeout );

  config.sync();
}


void ProtocolManager::setMarkPartial( bool _mode ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "MarkPartial", _mode );

  config.sync();
}


void ProtocolManager::setMinimumKeepSize( int _size ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "MinimumKeepSize", _size );

  config.sync();
}


void ProtocolManager::setAutoResume( bool _mode ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "AutoResume", _mode );

  config.sync();
}


void ProtocolManager::setPersistent( bool _mode ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "PersistentConnections", _mode );

  config.sync();
}


void ProtocolManager::setUseProxy( bool _mode ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "UseProxy", _mode );

  config.sync();
}


void ProtocolManager::setHttpProxy( const char* _proxy ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "HttpProxy", _proxy );

  config.sync();
}


void ProtocolManager::setNoProxyFor( const char* _noproxy ) {
  KConfig config(KApplication::kde_configdir() + "/kioslaverc",
		  KApplication::localconfigdir() + "/kioslaverc" );

  config.writeEntry( "NoProxyFor", _noproxy );

  config.sync();
}
