/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include <sys/types.h>
#include "bindDialog.h"
#include "bind.h"


void KBindWidget::fdelclicked()
{
forwarders->remove(flist->text(ftodel));
flist->removeItem(ftodel);
if(flist->count() == 0) delf->setEnabled(false);
}

void KBindWidget::xdelclicked()
{
xfrnets->remove(xlist->text(xtodel));
xlist->removeItem(xtodel);
if(xlist->count() == 0) delx->setEnabled(false);
}

void KBindWidget::bdelclicked()
{
bogusns->remove(blist->text(btodel));
blist->removeItem(btodel);
if(blist->count() == 0) delb->setEnabled(false);
}

void KBindWidget::flistsel(int a)
{
  ftodel=a;
  delf->setEnabled(true);
}

void KBindWidget::xlistsel(int a)
{
  xtodel=a;
  delx->setEnabled(true);
}

void KBindWidget::blistsel(int a)
{
  btodel=a;
  delb->setEnabled(true);
}


void KBindWidget::fnewclicked()
{
  bindDialog *bd;
  bd = new bindDialog(flist, forwarders, i18n("New Forwarder"), 
		      i18n("New Forwarder:"), this, "forw");
  bd->show();
}

void KBindWidget::xnewclicked()
{
  bindDialog *bd;
  bd = new bindDialog(xlist, xfrnets, i18n("New Xfer net"), 
		      i18n("New Xfer net:"), this, "xferd");
  bd->show();

}

void KBindWidget::bnewclicked()
{
  bindDialog *bd;
  bd = new bindDialog(blist, bogusns, i18n("New Bogus Nameserver"), 
		      i18n("New Bogus Nameserver:"), this, "bogd");
  bd->show();
}

void KBindWidget::StartClicked()
{
}

void KBindWidget::StopClicked()
{
}

void KBindWidget::RestartClicked()
{
  QFile *file = new QFile("/var/run/named.pid");
 
  if (!pid->isNull() )
    file->setName(*pid);
 
  if(file->open(IO_ReadOnly))
    {
	char tmp[255];
	int pid = 0;
	file->readLine(tmp,255);
	file->close();
	pid=atoi(tmp);
	printf("Sending SIGHUP to named (pid %u)\n",pid);
	kill(pid,SIGHUP);
    }
}

void KBindWidget::StatusClicked()
{
  statlist->clear();
  simplestatlist->clear();
  parselog();
}

void KBindWidget::DumpClicked()
{
  QFile *file = new QFile("/var/run/named.pid");
 
  if (!pid->isNull() )
    file->setName(*pid);
 
  if(file->open(IO_ReadOnly))
    {
	char tmp[255];
	int pid = 0;
	file->readLine(tmp,255);
	file->close();
	pid=atoi(tmp);
	printf("Sending SIGINT to named (pid %u)\n",pid);
	kill(pid,SIGINT);
    }
}
