/************************************************************
	Copyright (c) 1998 Olof Wolgast
        Copyright (c) 1998-1999 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#ifndef PRIMARYDOMAIN_CPP
#define PRIMARYDOMAIN_CPP

#include <qfile.h>
#include <qtextstream.h>

#include "primarydomain.h"

extern const char *TYPES2[];

PrimaryDomain::PrimaryDomain( QString dom, QString f ) 
{
  domain = dom;
  fileName = f;

  // This was moved from init.cpp.
  data = new (QList<record>);
  data->setAutoDelete(TRUE);

  // Puts a zero in all unused variables, this is so 
  // they will not show up in the config file later.
  org = 0;
  cl = 0;
  ns = 0;
  rp = 0;
  serial = 0;
  refresh = 0;
  retry = 0;
  expire = 0;
  checknames = 0;
  TTL = 0;
  notify = false;
  type = 0;
}

PrimaryDomain::~PrimaryDomain() //Needed to delete objects which don't inherit QObject.
{
  delete data;
  delete rl;
  delete alsonotify;
}

void PrimaryDomain::save( QString directory, QTextStream *configStream,
			  bool auto_rl, bool write_newstyle)
{
  QString reverseDomain;
  int i, i2;
  char tmp[100], *tmp2, tmp3[100];
  
  QFile f( directory + '/'+ fileName );    
  QTextStream t( &f );
  if ( f.open( IO_WriteOnly ) ) 
    {            
      t << "@\tIN\tSOA\t" << domain << ". " << rp << " (\n"
	<< "\t\t\t" << serial << "\t ; serial\n"
	<< "\t\t\t" << refresh << "\t\t ; refresh, seconds\n"
	<< "\t\t\t" << retry << "\t\t ; retry, seconds\n"
	<< "\t\t\t" << expire << "\t\t ; expire, seconds\n"
	<< "\t\t\t" << TTL << " )\t\t ; minimum, seconds\n\n";
      
      for ( rl = data->first(); rl != 0; rl = data->next() ) 
	{
	  t << rl->owner;
	  if(rl->owner.length() >= 8)
	    t << "\tIN\t";
	  if(rl->owner.length() < 8)
	    t << "\t\tIN\t";
	  t << TYPES2[rl->type] << "\t";
	  if ( strcmp( TYPES2[rl->type], "MX") == 0 ) t << rl->i << " ";
	  t << rl->st1 << " " << rl->st2 << "\n";
	}
      f.close();  
    } 

  //////////////////Start reverse handling///////////////////////
  if(auto_rl)
  {
    tmp[1] = '\0';
    for ( rl = data->first(); rl != 0; rl = data->next() ) //Get the first to have something to compare with.
       {
         if ( strcmp( TYPES2[ rl->type ] , "A") == 0 )
	   {
	     reverseDomain = ( const char * ) rl->st1;
	     break;
	   }
       }
    for ( rl = data->first(); rl != 0; rl = data->next() ) //Now determine the least common to determine network class.
       {
         if ( strcmp( TYPES2[ rl->type ] , "A" ) == 0 )
	   {
	     for( i = 0; ( ( const char * ) rl->st1 )[ i ] == ( ( const char * ) reverseDomain )[ i ]; i++ )
	       {
	       }
	     reverseDomain = ( const char * ) 0;
	     i2 = 0;
	     while ( i > i2  )
	       {
	         tmp[0] = ( ( const char * ) rl->st1 )[i2];
	         reverseDomain.append( tmp );
	         i2++;	
	       }
	   }
       }
     strcpy( tmp, ( const char * ) reverseDomain );
     strcpy( tmp3, tmp );
     reverseDomain = ( const char * ) 0;
     tmp2 = strtok( tmp, "." );
     while ( tmp2 != 0 ) //Turn it around to create the reverse domain.
       {
         reverseDomain.prepend( tmp2 );
         reverseDomain.prepend( "." );
         tmp2 = strtok( 0, "." );
       }
     reverseDomain = ( const char * ) reverseDomain.right( reverseDomain.length() - 1 );

     f.setName( directory + "/db." + reverseDomain + ".in-addr.arpa" );
     if ( f.open( IO_WriteOnly ) )
       {
         t.setDevice( &f );
         t << "@\tIN\tSOA\t" << domain << ". " << rp << " (\n"
	   << "\t\t\t" << serial << "\t ; serial\n"
	   << "\t\t\t" << refresh << "\t\t ; refresh, seconds\n"
	   << "\t\t\t" << retry << "\t\t ; retry, seconds\n"
	   << "\t\t\t" << expire << "\t\t ; expire, seconds\n"
	   << "\t\t\t" << TTL << " )\t\t ; minimum, seconds\n\n";
       
         for ( rl = data->first(); rl != 0; rl = data->next() )
	   {
	     if ( strcmp( TYPES2[rl->type ], "A" ) == 0 )
	       {
	         if ( strcmp( ( const char * ) rl->owner.right( 1 ), "." ) != 0 )
		   {
		     rl->owner = rl->owner + '.' + domain +'.';
		   }
	         rl->st1 = rl->st1.right( rl->st1.length() - strlen( tmp3 ) );
	       
	         t << rl->st1
		   << "\t\tIN\tPTR\t\t"
		   << rl->owner << "\n" ;
	       }
	     else if ( strcmp( TYPES2[rl->type ], "NS" ) == 0 )
	       {
	         t << rl->owner;
	         if(rl->owner.length() >= 8)
		   t << "\tIN\t";
	         if(rl->owner.length() < 8)
		   t << "\t\tIN\t";
	         t << TYPES2[rl->type] << "\t";
	         //if ( strcmp( TYPES2[rl->type], "MX") == 0 ) t << rl->i << " ";
	         t << rl->st1 << " " << rl->st2 << "\n";
	       }
	   }

       if(!write_newstyle)
	 *configStream << "primary\t\t" << reverseDomain << ".in-addr.arpa\t\t" << ( "db." + reverseDomain + ".in-addr.arpa\n" );
       else
	 *configStream << "zone \"" << reverseDomain << ".in-addr.arpa" << "\" {\n\ttype master;\n" << "\tfile \"" 
		       << ( "db." + reverseDomain + ".in-addr.arpa" ) << "\";\n};\n\n";

       f.close();  
     }
  }
}

#endif






