/***********************************************************
	Copyright (c) 1998-1999 Karl Backstrm

	This code is under GPL - see COPYING.
************************************************************/

#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#include <ktopwidget.h>
#include <kpanner.h>
#include <kmsgbox.h>
#include <time.h>        
#include <qlined.h>
#include <ktabctl.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qchkbox.h>
#include <qfile.h>
#include <qtstream.h>
#include <qtextstream.h>

#include "dhcp.h"
#include "scopeDialog.h"
#include "leasesDialog.h"

#include "dhcp.moc"

DhcpWidget::DhcpWidget(QWidget *parent, const char *name):
  KConfigWidget(parent, name)
{
  QBoxLayout *topLayout = new QHBoxLayout(this, 5);
  QBoxLayout *buttonLayout = new QVBoxLayout();
  
    scopes = new QListBox(this);
    scopes->setMinimumWidth(100);
    topLayout->addWidget(scopes,5);
    
    topLayout->addLayout(buttonLayout);

    /*    options = new QListBox(this);
    options->setMinimumWidth(100);
    topLayout->addWidget(options,5);*/

    addButton = new QPushButton(i18n("Create"),this);
    addButton->setMinimumSize(addButton->sizeHint());
    buttonLayout->addWidget(addButton);
    connect( addButton, SIGNAL(clicked()), SLOT(createScope()));

    delButton = new QPushButton(i18n("Delete"),this);
    delButton->setMinimumSize(delButton->sizeHint());
    buttonLayout->addWidget(delButton);
    connect( delButton, SIGNAL(clicked()), SLOT(deleteScope()));
   
    propButton = new QPushButton(i18n("Properties"),this);
    propButton->setMinimumSize(propButton->sizeHint());
    buttonLayout->addWidget(propButton);
    connect( propButton, SIGNAL(clicked()), SLOT(propScope()));

    leasesButton = new QPushButton(i18n("Leases"),this);
    leasesButton->setMinimumSize(leasesButton->sizeHint());
    buttonLayout->addWidget(leasesButton);
    connect( leasesButton, SIGNAL(clicked()), SLOT(leasesScope()));

    buttonLayout->addStretch(5);

    init();
    
    topLayout->activate();

    setMinimumHeight(400);

}

bool DhcpWidget::isIP(QString ip)
{
   int n=0;
   QRegExp r = QRegExp("*.*.*.*",TRUE,TRUE);
   n=ip.contains(r);
   return n==4;
}

void DhcpWidget::applySettings()
{
  scopeAddresses *sa;
  QString temp2;
  QTextStream t;
  QFile f;

  f.setName("/etc/dhcpd.conf");    
  if ( f.open(IO_WriteOnly) ) 
    {            
      t.setDevice( &f );        
      QString s;
      for (sa=scopeList->first();sa!=0;sa=scopeList->next())
	{
	  t << "subnet" << " " << sa->subnet << " netmask " << sa->subnetMask << " {\n";
	  for (s=sa->include->first();s!=0;s=sa->include->next())
	    t << "\trange " << s.replace( QRegExp("-"), " " ) << ";\n";
	  if(sa->leaseDurations >= 0)
	    t << "\tdefault-lease-time " << sa->leaseDurations << ";\n";
	  if(sa->maxLeaseDurations >= 0)
	    t << "\tmax-lease-time " << sa->maxLeaseDurations << ";\n";
	  if( strcmp( sa->broadcastAddress, "" ) != 0 )
	    t << "\toption broadcast-address " << sa->broadcastAddress << ";\n";
	  if( strcmp( sa->domainName, "" ) != 0 )
	    t << "\toption domain-name \"" << sa->domainName << "\";\n";
	  if( strcmp( sa->nameServers, "" ) != 0 )
	    t << "\toption domain-name-servers " << sa->nameServers << ";\n";
	  if( strcmp( sa->routers, "" ) != 0 )
	    t << "\toption routers " << sa->routers << ";\n";
	  if(sa->timeOffset > 0)
	    t << "\toption time-offset " << sa->timeOffset << ";\n";
	  if(sa->ipForward)
	    t << "\toption ip-forwarding on;\n";

	  if( strcmp( sa->netbiosNameServers, "" ) != 0 )
	    t << "\toption netbios-name-servers " << sa->netbiosNameServers << ";\n";
	  if( strcmp( sa->netbiosDDServer, "" ) != 0 )
	    t << "\toption netbios-dd-server " << sa->netbiosDDServer << ";\n";
	  if(sa->netbiosNodeType > 0)
	    t << "\toption netbios-node-type " << sa->netbiosNodeType << ";\n";
	  if( strcmp( sa->nisDomain, "" ) != 0 )
	    t << "\toption nis-domain \"" << sa->nisDomain << "\";\n";
	  if( strcmp( sa->nisServers, "" ) != 0 )
	    t << "\toption nis-servers " << sa->nisServers << ";\n";
	  if( strcmp( sa->displayManager, "" ) != 0 )
	    t << "\toption x-display-manager " << sa->displayManager << ";\n";
	  if( strcmp( sa->fontServers, "" ) != 0 )
	    t << "\toption font-servers " << sa->fontServers << ";\n";
	  if( strcmp( sa->ntpServers, "" ) != 0 )
	    t << "\toption ntp-servers " << sa->ntpServers << ";\n";
	  if( strcmp( sa->swapServer, "" ) != 0 )
	    t << "\toption swap-server " << sa->swapServer << ";\n";
	  if( strcmp( sa->impressServers, "" ) != 0 )
	    t << "\toption impress-servers " << sa->impressServers << ";\n";
	  if( strcmp( sa->resourceLocationServers, "" ) != 0 )
	    t << "\toption resource-location-servers " << sa->resourceLocationServers << ";\n";
	  if( strcmp( sa->lprServers, "" ) != 0 )
	    t << "\toption lpr-servers " << sa->lprServers << ";\n";
	  if( strcmp( sa->cookieServers, "" ) != 0 )
	    t << "\toption cookie-servers " << sa->cookieServers << ";\n";
	  if( strcmp( sa->logServers, "" ) != 0 )
	    t << "\toption log-servers " << sa->logServers << ";\n";
	  if( strcmp( sa->ien116nameServers, "" ) != 0 )
	    t << "\toption ien116-name-servers " << sa->ien116nameServers << ";\n";
	  if( strcmp( sa->timeServers, "" ) != 0 )
	    t << "\toption time-servers " << sa->timeServers << ";\n";
	  t << "}\n\n";
	}
      f.close();
    }
}

void DhcpWidget::createScope()
{
  scopeAddresses *sa = new scopeAddresses("", "" );
  scopeList->append(sa);
  scopeDialog *s = new scopeDialog(sa,this, "s");
  s->show();
  displaySettings();
}

void DhcpWidget::deleteScope()
{
  if(scopes->currentItem() != -1)
    {
      scopeList->remove(scopes->currentItem());
      displaySettings();
    }
}

void DhcpWidget::propScope()
{
  if(scopes->currentItem() != -1)
    {
      scopeDialog *s = new scopeDialog(scopeList->at(scopes->currentItem()),this, "s");
      s->show();
    }
    displaySettings();
}

void DhcpWidget::leasesScope()
{
  if(scopes->currentItem() != -1)
    {
      int i,i2, num = 0;
      QString tmp,tmp1;
      scopeAddresses *sl;
      sl = scopeList->at(scopes->currentItem());
      for (tmp=sl->include->first();tmp!=0;tmp=sl->include->next()) 
	{
	  i = tmp.find("-");
	  tmp1 = tmp.left(i);
	  tmp1 = tmp1.right(tmp1.length()-tmp1.findRev(".",tmp1.length())-1);
	  i = tmp1.toInt();
	  tmp1 = tmp.right(tmp.length()-tmp.findRev(".",tmp.length())-1);
	  i2 = tmp1.toInt();
	  num += i2-i+1;
	}
      
      leasesDialog *s = new leasesDialog(scopes->text(scopes->currentItem()),num,this, "s");
      s->show();
    }
}
