/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "leasesDialog.h"
#include "leasesDialog.moc"
#include <qlayout.h>


leasesDialog::leasesDialog (const char* ipscope, int num,
			    QWidget* parent, const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{
  number = num;
  QBoxLayout *topLayout = new QVBoxLayout(this, 10);
  QGridLayout *activeLayout = new QGridLayout(3, 2);
  QGridLayout *propLayout = new QGridLayout(6, 2);
  QBoxLayout *leasesLayout = new QVBoxLayout();
  QBoxLayout *buttonLayout = new QHBoxLayout();

  topLayout->addLayout(activeLayout);
  topLayout->addSpacing(20);
  topLayout->addLayout(propLayout);
  topLayout->addLayout(leasesLayout);

  activeLayout->setColStretch(1,10);
  propLayout->setColStretch(1,10);

  label = new QLabel(i18n("Total addresses in Scope:"),this);
  label->setMinimumSize(label->sizeHint());
  activeLayout->addWidget(label,0,0);

  label = new QLabel(i18n("Active Leases:"),this);
  label->setMinimumSize(label->sizeHint());
  activeLayout->addWidget(label,1,0);

  label = new QLabel(i18n("Avaible:"),this);
  label->setMinimumSize(label->sizeHint());
  activeLayout->addWidget(label,2,0);

  ed1 = new QLabel("1",this);
  ed1->setMinimumSize(ed1->sizeHint());
  activeLayout->addWidget(ed1,0,1);

  ed2 = new QLabel("2",this);
  ed2->setMinimumSize(ed2->sizeHint());
  activeLayout->addWidget(ed2,1,1);

  ed3 = new QLabel("3",this);
  ed3->setMinimumSize(ed3->sizeHint());
  activeLayout->addWidget(ed3,2,1);

  label = new QLabel(i18n("IP:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,0,0);

  label = new QLabel(i18n("Hostname:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,1,0);

  label = new QLabel(i18n("Starts:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,2,0);

  label = new QLabel(i18n("Ends:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,3,0);

  label = new QLabel(i18n("Uid:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,4,0);

  label = new QLabel(i18n("Hardware:"),this);
  label->setMinimumSize(label->sizeHint());
  propLayout->addWidget(label,5,0);

  p1 = new QLabel(i18n("Empty"),this);
  p1->setMinimumSize(p1->sizeHint());
  propLayout->addWidget(p1,0,1);

  p2 = new QLabel(i18n("Empty"),this);
  p2->setMinimumSize(p2->sizeHint());
  propLayout->addWidget(p2,1,1);

  p3 = new QLabel(i18n("Empty"),this);
  p3->setMinimumSize(p3->sizeHint());
  propLayout->addWidget(p3,2,1);

  p4 = new QLabel(i18n("Empty"),this);
  p4->setMinimumSize(p4->sizeHint());
  propLayout->addWidget(p4,3,1);

  p5 = new QLabel(i18n("Empty"),this);
  p5->setMinimumSize(p5->sizeHint());
  propLayout->addWidget(p5,4,1);

  p6 = new QLabel(i18n("Empty"),this);
  p6->setMinimumSize(p6->sizeHint());
  propLayout->addWidget(p6,5,1);

  leasesListBox = new KTabListBox(this, "", 2);
  leasesListBox->setFixedSize(400,150);
  leasesListBox->setColumn(0,i18n("IP number"), 200);
  leasesListBox->setColumn(1,i18n("Name"), 190);
  leasesLayout->addWidget(leasesListBox, 10);
  connect( leasesListBox, SIGNAL(highlighted(int,int)), SLOT(leasesListSel(int,int)) );
  
  topLayout->addLayout(buttonLayout);
  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );

  Update_Button = new QPushButton(i18n("Update"), this);
  Update_Button->setFixedSize(Update_Button->sizeHint());
  connect( Update_Button, SIGNAL(clicked()), SLOT(Update_Click()) );
  buttonLayout->addWidget(Update_Button);

  Exit_Button = new QPushButton(i18n("Exit"), this);
  Exit_Button->setFixedSize(Exit_Button->sizeHint());
  connect( Exit_Button, SIGNAL(clicked()), SLOT(Exit_Click()) );
  buttonLayout->addWidget(Exit_Button);

  Subnet = new QString(ipscope);
  setCaption(ipscope);
  setFixedSize(50,50);
  init();
  topLayout->activate();
}


leasesDialog::~leasesDialog()
{
}

void leasesDialog::leasesListSel(int i,int c)
{
  QString tmp;
  leasesAddress *la;
  for(la=leasesList->first(); strcmp((const char*)la->ip,leasesListBox->text(leasesListBox->currentItem(),0)); la=leasesList->next());
  p1->setText((const char*)la->ip);
  p2->setText((const char*)la->hostName);
  tmp = la->startsDate+" "+la->startsTime;
  p3->setText((const char*)tmp);
  tmp = la->endsDate+" "+la->endsTime;
  p4->setText((const char*)tmp);
  p5->setText((const char*)la->uid);
  tmp = la->hardwareType+" "+la->hardwareAddress;
  p6->setText((const char*)tmp);
}

void leasesDialog::init()
{

  update();
}

void leasesDialog::Update_Click()
{

  update();
}

void leasesDialog::Exit_Click()
{
  close();
}

void leasesDialog::update()
{
  char tmp[70000];
  QString st,st1,st2, st3;
  leasesAddress *la;
  leasesList = new QList<leasesAddress>();
  int s1, s2, s3, times, e=0;

  QFile configFile( "/etc/dhcpd.leases" );
  QString configData, currentRow;
  QList< QString > parameterList;
  QString *parameterListItemToRemove;
  int i;

  parameterList.setAutoDelete( TRUE );      
  configFile.open( IO_ReadOnly );
  configFile.readBlock( tmp, configFile.size() );
  configFile.close();
  configData = tmp;
  while ( configData.find( '\t' ) != -1 ) //replace all tabs with whitespace.
    {
      i = configData.find( '\t' );
      configData.replace( i, 1, " " );
    }
  
  while ( configData.find( ';' ) != -1 ) // Remove this ;
    {
      i = configData.find( ';' );
      configData.remove(i, 1);
    }

  while ( configData.find( '\"' ) != -1 ) // Remove this "
    {
      i = configData.find( '\"' );
      configData.remove(i, 1);
    }

  if(configData.find("}") > -1 )
    {
      s1 = configData.find("}");
      s2 = configData.find("{");
      if(configData.find("{",(s2+1)) != -1)
	{
	  s2 = configData.find("{",(s2+1));
	  if(s2>s1) {}
	  else
	    {
	      times = 1;
	      while(times != 0 && s1 != -1) //||
		{
		  s3 = s1;
		  s1 = configData.find("}",(s3+1));
		  s2 = configData.find("{",(s3+1));
		  if(s2>s1) --times;
		}
	    }
	  if(0 >= s1)
	    s1 = configData.length() - 2;
	}
      
      currentRow = ( const char * ) configData.left((s1+1));
      configData = ( const char * ) configData.right( configData.length() - (s1+2));
      currentRow = currentRow.simplifyWhiteSpace();
    }
  else 
    {
      currentRow = 0;
    }
  
  for( i = 0; currentRow.find( " " ) != - 1; i++ )
    {
      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
    }
  parameterList.append( new QString( ( const char * ) currentRow ) ); 
  
  while ( currentRow.isEmpty() != true )
    {
      if ( strcmp( ( const char * ) *parameterList.first(), "lease" ) == 0 )
	{ 
	  QString *tmp1 = parameterList.next();
	  la = new leasesAddress((const char*)*tmp1);
	  leasesList->inSort(la);
	  QString *tmp = parameterList.next();
	  while ( tmp != 0 )
	    {
	      if (strcmp( ( const char * ) *tmp, "{" ) == 0 )
		{
		}
	      else if ( strcmp( ( const char * ) *tmp, "starts" ) == 0 )
		{
		  tmp = parameterList.next(); 
		  tmp = parameterList.next();
		  la->startsDate = (const char*)*tmp;
		  tmp = parameterList.next();
		  la->startsTime = (const char*)*tmp;
		}
	       else if ( strcmp( ( const char * ) *tmp, "ends" ) == 0 )
		{
		  tmp = parameterList.next(); 
		  tmp = parameterList.next();
		  la->endsDate = (const char*)*tmp;
		  tmp = parameterList.next();
		  la->endsTime = (const char*)*tmp;
		}
	       else if ( strcmp( ( const char * ) *tmp, "hardware" ) == 0 )
		{
		  tmp = parameterList.next();
		  la->hardwareType = (const char*)*tmp;
		  tmp = parameterList.next();
		  la->hardwareAddress = (const char*)*tmp;
		}
	       else if ( strcmp( ( const char * ) *tmp, "uid" ) == 0 )
		{
		  tmp = parameterList.next();
		  la->uid = (const char*)*tmp;
		}
	       else if ( strcmp( ( const char * ) *tmp, "client-hostname" ) == 0 )
		{
		  tmp = parameterList.next();
		  la->hostName = (const char*)*tmp;
		  tmp1 = parameterList.next();
		  while(tmp1->find("}") == -1)
		     {
		       tmp->append(" ");
		       tmp->append((const char*)*tmp1);
		       la->hostName = (const char*)*tmp;
		       tmp1 = parameterList.next();
		     }
		}
	      else if ( strcmp( ( const char * ) *tmp, "}" ) == 0 )
		{
		}
	      else
		{
		  debug("Can't understand this (yet):");
		  debug(( const char * ) *tmp);
		}
	      tmp = parameterList.next();
	    }
	}
      for ( parameterListItemToRemove = parameterList.first(); //Clear the list.
	    parameterListItemToRemove != 0;
	    parameterListItemToRemove = parameterList.first() )
	{
	  parameterList.remove( parameterListItemToRemove );
	}
      if(configData.find("}") > -1 )
	{
	  s1 = configData.find("}");
	  s2 = configData.find("{");
	  if(configData.find("{",(s2+1)) != -1)
	    {
	      s2 = configData.find("{",(s2+1));
	      if(s2>s1) {}
	      else
		{
		  times = 1;
		  while(times != 0 && s1 != -1) //||
		    {
		      s3 = s1;
		      s1 = configData.find("}",(s3+1));
		      s2 = configData.find("{",(s3+1));
		      if(s2>s1) --times;
		    }
		}
		  if(0 >= s1)
		    s1 = configData.length() - 2;
	    }
	  
	  currentRow = ( const char * ) configData.left((s1+1));
	  configData = ( const char * ) configData.right( configData.length() - (s1+2));
	  currentRow = currentRow.simplifyWhiteSpace();
	}
      else 
	{
	  currentRow = 0;
	    }
      for( i = 0; currentRow.find( " " ) != - 1; i++ )
	{
	  parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	  currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	}
      parameterList.append( new QString( ( const char * ) currentRow ) );
    }
  if(Subnet->find(".0") >= 0)
    Subnet->remove(Subnet->find(".0"),2);
  leasesListBox->clear();
  for (la=leasesList->first();la!=0;la=leasesList->next()) 
    {
      if(la->ip.find((const char*)*Subnet) >= 0)
	{
	  leasesListBox->insertItem(la->ip+leasesListBox->separator()+la->hostName);     
	++e;
	} 
    }
  ed1->setNum(number);
  ed2->setNum(e);
  ed3->setNum(number-e);
}



